/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.ui.wizards.pages;

import edu.mit.jwi.IDictionary;
import edu.mit.parsing.core.rep.colloc.Colloc;
import edu.mit.parsing.core.rep.colloc.IColloc;
import edu.mit.parsing.core.rep.pos.IPosData;
import edu.mit.parsing.core.rep.pos.ITag;
import edu.mit.parsing.core.rep.pos.PennTag;
import edu.mit.parsing.core.rep.pos.PosData;
import edu.mit.parsing.core.rep.sentence.ISentence;
import edu.mit.parsing.core.rep.token.IBaseToken;
import edu.mit.parsing.core.rep.token.IToken;
import edu.mit.parsing.core.util.IBaseWordInfo;
import edu.mit.parsing.ui.widgets.WordInfoWidget;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IHasSegments;
import edu.mit.story.core.desc.Segment;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.PositionUtils;
import edu.mit.story.core.position.SimplePosition;
import edu.mit.story.core.util.StringUtils;
import edu.mit.story.ui.StoryUIPlugin;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.util.ColorFontStyler;
import edu.mit.wordnet.core.rep.sense.SenseRep;
import edu.mit.wordnet.core.rep.sense.dict.IExtendedDictionary;
import edu.mit.wordnet.core.rep.sense.disambiguation.DisambiguationModel;
import edu.mit.wordnet.core.rep.sense.disambiguation.IDisambiguationModel;
import edu.mit.wordnet.ui.WordnetUIMessages;
import edu.mit.wordnet.ui.controllers.DisambiguationController;
import edu.mit.wordnet.ui.controllers.IDisambiguationController;
import edu.mit.wordnet.ui.label.SenseAssignmentLabelProvider;
import edu.mit.wordnet.ui.wizards.WSDWizardDialog;
import edu.mit.wordnet.ui.wizards.pages.DefinitionViewer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class DisambiguationPage
extends WizardPage
implements ChangeListener {
    public static final String DEFAULT_NAME = StringUtils.getClassName(DisambiguationPage.class);
    private final IStoryEditor editor;
    protected IDisambiguationController controller;
    protected int fontHeight = 10;
    protected Composite pageParent;
    protected WordInfoWidget infoWidget;
    protected ProgressBar bar;
    protected Label progressCounter;
    protected Button collocAddButton;
    protected Button collocSubtractButton;
    protected Button clearCollocButton;
    protected Button setStemButton;
    protected Button setTagButton;
    protected Button setTagSingButton;
    protected Button setTagPlurButton;
    protected Button resetStemButton;
    protected Button resetTagButton;
    protected Button flagNoSenseButton;
    protected Button flagSkipButton;
    protected Button flagDeleteButton;
    protected Button clearChoiceButton;
    protected Button chooseArbButton;
    protected ContextView contextView;
    protected DefinitionViewer defView;
    protected CheckboxTableViewer defTable;

    public DisambiguationPage(IDesc desc, IStoryEditor editor) {
        this(DEFAULT_NAME, desc, editor);
    }

    public DisambiguationPage(String name, IDesc desc, IStoryEditor editor) {
        super(name);
        if (editor == null) {
            throw new NullPointerException();
        }
        this.editor = editor;
        this.setTitle(WordnetUIMessages.PAGE_WSDDisambigation_title);
        this.setImageDescriptor(StoryUIPlugin.getDefault().getImageRegistry().getDescriptor("wizban/importstory_wiz.gif"));
        this.setModel((IDisambiguationModel)new DisambiguationModel(desc, (IStoryModel)editor.getStoryModel()));
    }

    public IDisambiguationController getController() {
        return this.controller;
    }

    public void setModel(IDisambiguationModel newModel) {
        IDisambiguationModel oldModel;
        IDisambiguationModel iDisambiguationModel = oldModel = this.controller == null ? null : this.controller.getModel();
        if (newModel == oldModel) {
            return;
        }
        if (this.controller != null) {
            this.controller.getModel().removeChangeListener((ChangeListener)this);
            this.controller.stopTimer();
        }
        this.controller = new DisambiguationController(newModel, this.editor);
        this.controller.getModel().addChangeListener((ChangeListener)this);
        this.controller.startTimer();
    }

    public boolean isPageComplete() {
        return this.controller.getModel().getMessageType() != 3;
    }

    public void stateChanged(ChangeEvent e) {
        this.updateFromModel();
    }

    public boolean setKeyboardFocusToTable() {
        return this.defTable.getTable().forceFocus();
    }

    public void createControl(Composite parent) {
        GC gc = new GC((Drawable)parent);
        this.fontHeight = gc.getFontMetrics().getHeight();
        gc.dispose();
        this.pageParent = new Composite(parent, 0){

            public boolean setFocus() {
                return DisambiguationPage.this.setKeyboardFocusToTable();
            }
        };
        this.pageParent.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.pageParent.setLayout((Layout)layout);
        this.setControl((Control)this.pageParent);
        this.createStatusBox(this.pageParent);
        this.createButtons(this.pageParent);
        this.createContextBox(this.pageParent);
        this.createDefinitionView(this.pageParent);
        this.createDefinitionTable(this.pageParent);
        this.updateFromModel();
    }

    protected void createStatusBox(Composite parent) {
        Composite statusGroup = new Composite(parent, 0);
        GridData gd = new GridData(4, 4, true, false);
        statusGroup.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.marginBottom = 0;
        statusGroup.setLayout((Layout)layout);
        Group group = new Group(statusGroup, 0);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText("Current Word");
        group.setLayout((Layout)new GridLayout());
        this.infoWidget = new WordInfoWidget((Composite)group, 0, false);
        this.infoWidget.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(statusGroup, 0);
        label.setLayoutData((Object)new GridData(4, 4, true, false));
        label.setText("Word Context:");
    }

    protected void createButtons(Composite parent) {
        Composite buttonGroup = new Composite(parent, 0);
        GridData gd = new GridData(16384, 4, false, false);
        gd.horizontalSpan = 2;
        buttonGroup.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout(4, false);
        buttonGroup.setLayout((Layout)layout);
        this.collocAddButton = new Button(buttonGroup, 0);
        this.collocAddButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.collocAddButton.setText("Add to");
        this.collocAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DisambiguationPage.this.controller.addTo(DisambiguationPage.this.contextView.getSelectedTokens());
            }
        });
        this.collocSubtractButton = new Button(buttonGroup, 0);
        this.collocSubtractButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.collocSubtractButton.setText("Subtract from");
        this.collocSubtractButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DisambiguationPage.this.controller.subtractFrom(DisambiguationPage.this.contextView.getSelectedTokens());
            }
        });
        new Label(buttonGroup, 0);
        this.clearCollocButton = new Button(buttonGroup, 0);
        this.clearCollocButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.clearCollocButton.setText("Clear Collocation");
        this.clearCollocButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DisambiguationPage.this.controller.getWordController().clear();
            }
        });
        this.setStemButton = new Button(buttonGroup, 0);
        this.setStemButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.setStemButton.setText("Correct Stem");
        this.setStemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DisambiguationPage.this.controller.correctStem();
            }
        });
        new Label(buttonGroup, 0);
        new Label(buttonGroup, 0);
        this.resetStemButton = new Button(buttonGroup, 0);
        this.resetStemButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.resetStemButton.setText("Reset Stem");
        this.resetStemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DisambiguationPage.this.controller.clearStem();
            }
        });
        this.setTagButton = new Button(buttonGroup, 0);
        this.setTagButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.setTagButton.setText("Correct Tag");
        this.setTagButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DisambiguationPage.this.controller.correctTag();
            }
        });
        this.setTagSingButton = new Button(buttonGroup, 0);
        this.setTagSingButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.setTagSingButton.setText("Singular Proper");
        this.setTagSingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DisambiguationPage.this.controller.setTag((IPosData)new PosData((ITag)PennTag.NNP, false));
            }
        });
        this.setTagPlurButton = new Button(buttonGroup, 0);
        this.setTagPlurButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.setTagPlurButton.setText("Plural Proper");
        this.setTagPlurButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DisambiguationPage.this.controller.setTag((IPosData)new PosData((ITag)PennTag.NNPS, false));
            }
        });
        this.resetTagButton = new Button(buttonGroup, 0);
        this.resetTagButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.resetTagButton.setText("Reset Tag");
        this.resetTagButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DisambiguationPage.this.controller.clearTag();
            }
        });
        this.flagDeleteButton = new Button(buttonGroup, 0);
        this.flagDeleteButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.flagDeleteButton.setText("Delete");
        this.flagDeleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DisambiguationPage.this.controller.setDelete();
            }
        });
        this.flagNoSenseButton = new Button(buttonGroup, 0);
        this.flagNoSenseButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.flagNoSenseButton.setText("No Sense");
        this.flagNoSenseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DisambiguationPage.this.controller.setNoSense();
            }
        });
        this.flagSkipButton = new Button(buttonGroup, 0);
        this.flagSkipButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.flagSkipButton.setText("Skip");
        this.flagSkipButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DisambiguationPage.this.controller.setSkipping();
            }
        });
        this.clearChoiceButton = new Button(buttonGroup, 0);
        this.clearChoiceButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.clearChoiceButton.setEnabled(false);
        this.clearChoiceButton.setText("Clear Selection");
        this.clearChoiceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DisambiguationPage.this.controller.setChoice(null);
            }
        });
    }

    protected void createContextBox(Composite pageParent) {
        this.contextView = new ContextView(pageParent, 2048);
        GridData gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 3;
        gd.heightHint = 5 * this.fontHeight;
        gd.widthHint = 20 * this.fontHeight;
        this.contextView.setLayoutData(gd);
    }

    protected void createDefinitionView(Composite pageParent) {
        Label label = new Label(pageParent, 0);
        GridData gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 3;
        label.setLayoutData((Object)gd);
        label.setText("Chosen Definition:");
        IExtendedDictionary dict = SenseRep.getDictionary((IStoryData)this.controller.getModel().getStoryModel().getData());
        this.defView = new DefinitionViewer(pageParent, 2048, (IDictionary)dict);
        gd = new GridData(4, 4, true, true);
        gd.heightHint = 10 * this.fontHeight;
        gd.minimumHeight = 3 * this.fontHeight;
        gd.horizontalSpan = 3;
        this.defView.setLayoutData(gd);
    }

    protected void createDefinitionTable(Composite parent) {
        Label label = new Label(parent, 0);
        GridData data = new GridData(4, 1024, true, false);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label.setText("Potential Definitions:");
        this.chooseArbButton = new Button(parent, 0);
        this.chooseArbButton.setLayoutData((Object)new GridData(131072, 4, false, false));
        this.chooseArbButton.setText("Arbitrary Sense");
        this.chooseArbButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DisambiguationPage.this.controller.chooseArbitrary();
            }
        });
        this.defTable = CheckboxTableViewer.newCheckList((Composite)parent, (int)68100);
        Table table = this.defTable.getTable();
        data = new GridData(4, 4, true, true);
        data.horizontalSpan = 3;
        data.heightHint = this.fontHeight * Math.max(11, this.controller.getModel().getChoices().size());
        data.widthHint = 1;
        table.setLayoutData((Object)data);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn column = new TableColumn(table, 16384);
        column.setText("Synonyms");
        column = new TableColumn(table, 16384);
        column.setText("ID");
        column = new TableColumn(table, 16384);
        column.setText("Sense Key");
        column = new TableColumn(table, 16384);
        column.setText("Gloss");
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(10));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(4));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(10));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(40));
        table.setLayout((Layout)tableLayout);
        this.defTable.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.defTable.setLabelProvider((IBaseLabelProvider)new SenseAssignmentLabelProvider(false, true));
        this.defTable.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DisambiguationPage.this.controller.setChoice(DisambiguationPage.this.defTable.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
                DisambiguationPage.this.choiceDefaultSelected(e);
            }
        });
        this.defTable.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                switch (e.keyCode) {
                    case 0x1000004: {
                        DisambiguationPage.this.doNextPage();
                        break;
                    }
                    case 0x1000003: {
                        DisambiguationPage.this.doPreviousPage();
                        break;
                    }
                    case 0x1000002: {
                        if (!DisambiguationPage.this.defTable.getSelection().isEmpty() || DisambiguationPage.this.defTable.getTable().getItemCount() <= 0) break;
                        DisambiguationPage.this.defTable.getTable().setSelection(0);
                        break;
                    }
                    case 0x1000001: {
                        if (!DisambiguationPage.this.defTable.getSelection().isEmpty() || DisambiguationPage.this.defTable.getTable().getItemCount() <= 0) break;
                        DisambiguationPage.this.defTable.getTable().setSelection(DisambiguationPage.this.defTable.getTable().getItemCount() - 1);
                    }
                }
            }
        });
    }

    protected void choiceDefaultSelected(SelectionEvent e) {
    }

    protected void doNextPage() {
        IWizardContainer container;
        if (this.isPageComplete() && this.canFlipToNextPage() && (container = this.getWizard().getContainer()) instanceof WSDWizardDialog) {
            WSDWizardDialog dialog = (WSDWizardDialog)container;
            dialog.nextPressed();
        }
    }

    protected void doPreviousPage() {
        IWizardContainer container = this.getWizard().getContainer();
        if (container instanceof WSDWizardDialog) {
            WSDWizardDialog dialog = (WSDWizardDialog)container;
            dialog.backPressed();
        }
    }

    protected void updateFromModel() {
        IPosData currTag;
        IDisambiguationModel model = this.controller.getModel();
        IBaseWordInfo orig = model.getModelInfo();
        IBaseWordInfo info = model.getCurrentInfo();
        this.infoWidget.setInput(info, null);
        this.defView.setAssignmentType(model.getAssignmentType());
        this.defView.setInput(model.getChosenSense());
        this.contextView.updateFromModel();
        boolean e = info.getPosTag().getTag().isStemmable();
        if (this.setStemButton.getEnabled() != e) {
            this.setStemButton.setEnabled(e);
        }
        boolean bl = e = !orig.getBaseForm().equals(info.getBaseForm());
        if (this.resetStemButton.getEnabled() != e) {
            this.resetStemButton.setEnabled(e);
        }
        boolean bl2 = e = !Colloc.getWordTokens((IDesc)model.getWordDesc()).equals((Object)Segment.extractSegmentDescriptions((IHasSegments)model.getWordModel()));
        if (this.clearCollocButton.getEnabled() != e) {
            this.clearCollocButton.setEnabled(e);
        }
        boolean bl3 = e = orig.getPosTag() != info.getPosTag();
        if (this.resetTagButton.getEnabled() != e) {
            this.resetTagButton.setEnabled(e);
        }
        boolean bl4 = e = model.getAssignmentType() == IDisambiguationModel.AssignmentType.NORMAL;
        if (this.chooseArbButton.getEnabled() != e) {
            this.chooseArbButton.setEnabled(e);
        }
        this.flagDeleteButton.setEnabled(model.getAssignmentType() != IDisambiguationModel.AssignmentType.DELETE);
        this.flagSkipButton.setEnabled(model.getAssignmentType() != IDisambiguationModel.AssignmentType.SKIP);
        this.flagNoSenseButton.setEnabled(model.getAssignmentType() != IDisambiguationModel.AssignmentType.NO_SENSE);
        boolean bl5 = e = model.getAssignmentType() != IDisambiguationModel.AssignmentType.NORMAL || model.getChoice() != null;
        if (this.clearChoiceButton.getEnabled() != e) {
            this.clearChoiceButton.setEnabled(e);
        }
        this.setTagSingButton.setEnabled((currTag = info.getPosTag()).getTag() != PennTag.NNP);
        this.setTagPlurButton.setEnabled(currTag.getTag() != PennTag.NNPS);
        this.updateAddSubtractButtons();
        Collection<Object> expected = Collections.emptySet();
        if (model.getAssignmentType() == IDisambiguationModel.AssignmentType.NORMAL) {
            expected = model.getChoices();
        }
        if (this.defTable.getInput() != expected) {
            this.defTable.setInput(expected);
        }
        StructuredSelection s = StructuredSelection.EMPTY;
        if (model.getChoice() != null) {
            s = new StructuredSelection(model.getChoice());
        }
        if (!s.equals(this.defTable.getSelection())) {
            this.defTable.setSelection((ISelection)s);
        }
    }

    protected void updateAddSubtractButtons() {
        String text = this.contextView.getStyledText().getSelectionText().trim();
        boolean isSelected = text.length() > 0;
        this.collocAddButton.setEnabled(isSelected);
        this.collocSubtractButton.setEnabled(isSelected && this.controller.getModel().getCurrentInfo().isCollocation());
    }

    public void dispose() {
        this.getController().getModel().dispose();
        super.dispose();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ContextView
    extends Composite
    implements ChangeListener {
        protected StyledString.Styler ADJACENT_STYLER;
        protected StyledString.Styler TARGET_STYLER;
        protected final StyledText styledText;
        protected final Map<IDesc, IHasPosition> ps;

        public ContextView(Composite parent, int style) {
            super(parent, style);
            this.ADJACENT_STYLER = new ColorFontStyler(Display.getDefault().getSystemColor(16), Display.getDefault().getSystemColor(25), 0);
            this.TARGET_STYLER = new ColorFontStyler(Display.getDefault().getSystemColor(3), Display.getDefault().getSystemColor(25), 0);
            this.ps = new HashMap<IDesc, IHasPosition>();
            Color white = Display.getDefault().getSystemColor(25);
            this.setForeground(parent.getForeground());
            this.setBackground(white);
            this.setLayout((Layout)new GridLayout());
            this.styledText = new StyledText((Composite)this, 74);
            this.styledText.setLayoutData((Object)new GridData(4, 4, true, true));
            this.styledText.setBackground(white);
            this.styledText.setForeground(parent.getForeground());
            this.styledText.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DisambiguationPage.this.updateAddSubtractButtons();
                }
            });
        }

        public StyledText getStyledText() {
            return this.styledText;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.updateFromModel();
        }

        public Set<IDesc> getSelectedTokens() {
            Point p = this.styledText.getSelectionRange();
            if (p.y == 0) {
                return null;
            }
            SimplePosition range = new SimplePosition(p.x, p.y);
            HashSet<IDesc> result = new HashSet<IDesc>();
            for (Map.Entry<IDesc, IHasPosition> entry : this.ps.entrySet()) {
                if (!PositionUtils.isIntersectionNonzero((IHasPosition)entry.getValue(), (IHasPosition)range)) continue;
                result.add(entry.getKey());
            }
            return result.isEmpty() ? null : result;
        }

        public void updateFromModel() {
            IDisambiguationModel model = DisambiguationPage.this.controller.getModel();
            List context = model.getContext();
            IBaseWordInfo info = model.getCurrentInfo();
            HashSet<IDesc> highlight = new HashSet<IDesc>();
            IBaseToken base = info.getBaseToken();
            if (base instanceof IToken) {
                highlight.add(model.getWordDesc());
            } else {
                IColloc c = (IColloc)base;
                highlight.addAll((Collection<IDesc>)c.getTokens());
            }
            this.ps.clear();
            StyledString text = new StyledString();
            for (ISentence s : context) {
                if (s != info.getSentence()) {
                    text.append(s.getDisplayText(), this.ADJACENT_STYLER);
                    continue;
                }
                for (IDesc d : s.getTokens()) {
                    int start = text.length();
                    IToken token = (IToken)d.getData();
                    if (highlight.contains(d)) {
                        text.append(token.getSurface(), this.TARGET_STYLER);
                    } else {
                        text.append(token.getSurface());
                    }
                    int end = text.length();
                    if (token.isFollowedByBreak()) {
                        text.append(' ');
                    }
                    this.ps.put(d, (IHasPosition)new SimplePosition(start, end - start));
                }
            }
            this.styledText.setText(text.toString());
            this.styledText.setStyleRanges(text.getStyleRanges());
        }
    }
}

