/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.preferences.editor;

import edu.mit.story.core.util.IEnableable;
import edu.mit.story.core.util.ReflectionUtils;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class PortFieldEditor
extends IntegerFieldEditor
implements IEnableable {
    private static final int lowPort = 0;
    private static final int highPort = 65535;
    private int low = 0;
    private int high = 65535;

    public PortFieldEditor(String prefName, String labelText, Composite parent) {
        this(prefName, labelText, parent, 5);
    }

    public PortFieldEditor(String prefName, String labelText, Composite parent, int textLimit) {
        super(prefName, labelText, parent, Math.min(textLimit, 5));
        this.setValidRange(0, 65535);
        this.setValidateStrategy(0);
    }

    public Label getLabelControl() {
        return super.getLabelControl();
    }

    public void setTextLimit(int limit) {
        ReflectionUtils.setFieldValue((Object)((Object)this), StringFieldEditor.class, (String)"widthInChars", (Object)limit);
        super.setTextLimit(limit);
    }

    protected boolean checkState() {
        try {
            int port = this.getIntValue();
            if (port < this.low | this.high < port) {
                this.setErrorMessage("The port must be between " + this.low + " and " + this.high);
            } else {
                this.setErrorMessage(JFaceResources.getString((String)"IntegerFieldEditor.errorMessage"));
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.setErrorMessage(JFaceResources.getString((String)"IntegerFieldEditor.errorMessage"));
        }
        return super.checkState();
    }

    public void setValidRange(int min, int max) {
        if (min < 0 || 65535 < max) {
            // empty if block
        }
        this.low = min;
        this.high = max;
        super.setValidRange(min, max);
    }

    public Text getPortField() {
        return this.getTextControl();
    }

    public boolean setEnabled(boolean value) {
        boolean current = this.isEnabled();
        if (current == value) {
            return false;
        }
        this.getPortField().setEnabled(value);
        this.getLabelControl().setEnabled(value);
        return true;
    }

    public boolean isEnabled() {
        return this.getPortField().isEnabled();
    }
}

