/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.preferences.editor;

import java.util.Map;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComboFieldEditor
extends FieldEditor {
    private Combo fCombo;
    protected String fValue;
    protected boolean fValid;
    protected Map<String, String> fNameToValue;

    public ComboFieldEditor(String prefName, String labelText, Map<String, String> entryNamesAndValues, Composite parent) {
        this.init(prefName, labelText);
        this.fNameToValue = entryNamesAndValues;
        this.createControl(parent);
    }

    protected Map<String, String> getNameToValueMap() {
        return this.fNameToValue;
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        if (control != null) {
            ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        }
        if ((control = this.getComboControl()) != null) {
            ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        }
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        control.setLayoutData((Object)gd);
        control = this.getComboControl(parent);
        gd = new GridData();
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        control.setLayoutData((Object)gd);
    }

    protected void doLoad() {
        this.setComboValue(this.getPreferenceStore().getString(this.getPreferenceName()));
    }

    protected void doLoadDefault() {
        this.setComboValue(this.getPreferenceStore().getDefaultString(this.getPreferenceName()));
    }

    protected void doStore() {
        if (this.fValue == null) {
            this.getPreferenceStore().setToDefault(this.getPreferenceName());
            return;
        }
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.fValue);
    }

    public int getNumberOfControls() {
        return 2;
    }

    public Combo getComboControl() {
        return this.fCombo;
    }

    public Combo getComboControl(Composite parent) {
        if (this.fCombo == null) {
            this.fCombo = new Combo(parent, 8);
            this.refreshCombo();
            this.fCombo.setFont(parent.getFont());
            this.fCombo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent evt) {
                    String oldValue = ComboFieldEditor.this.fValue;
                    boolean oldValid = ComboFieldEditor.this.fValid;
                    ComboFieldEditor.this.fValue = ComboFieldEditor.this.fNameToValue.get(ComboFieldEditor.this.fCombo.getText());
                    ComboFieldEditor.this.fValid = ComboFieldEditor.this.isValid();
                    ComboFieldEditor.this.setPresentsDefaultValue(false);
                    ComboFieldEditor.this.fireValueChanged("field_editor_value", oldValue, ComboFieldEditor.this.fValue);
                    ComboFieldEditor.this.fireStateChanged("field_editor_is_valid", oldValid, ComboFieldEditor.this.fValid);
                }
            });
        }
        return this.fCombo;
    }

    protected void refreshCombo() {
        this.fCombo.remove(0, this.fCombo.getItemCount() - 1);
        for (String name : this.fNameToValue.keySet()) {
            this.fCombo.add(name);
        }
    }

    protected void setComboValue(String value) {
        String name = null;
        for (Map.Entry<String, String> entry : this.fNameToValue.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            name = entry.getKey();
            break;
        }
        this.setComboName(name);
    }

    protected void setComboName(String name) {
        if (name == null) {
            if (this.getComboControl().getItemCount() == 0) {
                this.fCombo.select(0);
            }
            return;
        }
        int i = 0;
        while (i < this.fCombo.getItemCount()) {
            if (this.fCombo.getItem(i).equals(name)) {
                this.fCombo.select(i);
                break;
            }
            ++i;
        }
    }
}

