/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.ops;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import edu.mit.story.core.datamodel.IBatchPairModel;
import edu.mit.story.core.datamodel.IMergeTargetsModel;
import edu.mit.story.core.datamodel.MergeTargetsModel;
import edu.mit.story.core.merge.IMergeModel;
import edu.mit.story.ui.ops.MergeOperation;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class MergeBatchOperation
extends WorkspaceModifyOperation {
    private final IMergeModel transferModel;
    private final IBatchPairModel pairsModel;

    public MergeBatchOperation(IMergeModel transferModel, IBatchPairModel pairsModel) {
        if (transferModel == null) {
            throw new NullPointerException();
        }
        if (pairsModel == null) {
            throw new NullPointerException();
        }
        this.transferModel = transferModel;
        this.pairsModel = pairsModel;
    }

    protected void execute(IProgressMonitor pm) throws CoreException, InvocationTargetException, InterruptedException {
        pm.beginTask("Merging files...", this.pairsModel.getResourcePairs().size());
        for (Table.Cell cell : this.pairsModel.getResourcePairs().cellSet()) {
            if (!((Boolean)cell.getValue()).booleanValue()) continue;
            try {
                this.processPair((IFile)cell.getRowKey(), (IFile)cell.getColumnKey(), pm);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.failWithMessage(String.valueOf(((IFile)cell.getRowKey()).getName()) + ":\n" + Strings.nullToEmpty((String)e.getMessage()));
            }
        }
        pm.done();
    }

    protected void failWithMessage(final String message) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Alignment Problem", (String)message);
            }
        });
    }

    protected void processPair(IFile srcFile, IFile tgtFile, IProgressMonitor pm) throws CoreException, InvocationTargetException, InterruptedException {
        File outputDir = this.pairsModel.getOutputFile();
        File outputFile = new File(outputDir, srcFile.getName());
        if (outputFile.exists()) {
            throw new IllegalStateException("Output file already exists: " + outputFile.getName());
        }
        MergeTargetsModel pairModel = new MergeTargetsModel();
        pairModel.setSource(srcFile.getLocation().toFile());
        pairModel.setTarget(tgtFile.getLocation().toFile());
        pairModel.setOutput(outputFile);
        pairModel.setSourceTag(this.pairsModel.getSourceTag());
        pairModel.setTargetTag(this.pairsModel.getTargetTag());
        Sets.SetView mismatch = Sets.difference((Set)pairModel.getSourceModel().getSupported(), (Set)this.transferModel.getSupportedSource());
        if (!mismatch.isEmpty()) {
            throw new IllegalStateException("Source file does not match source profile: " + srcFile.getName() + " : " + mismatch);
        }
        mismatch = Sets.difference((Set)pairModel.getTargetModel().getSupported(), (Set)this.transferModel.getSupportedTarget());
        if (!mismatch.isEmpty()) {
            throw new IllegalStateException("Source file does not match source profile: " + srcFile.getName() + " : " + mismatch);
        }
        MergeOperation op = new MergeOperation(this.transferModel, (IMergeTargetsModel)pairModel);
        op.execute((IProgressMonitor)new SubProgressMonitor(pm, 1));
    }
}

