/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.dialogs;

import edu.mit.story.ui.StoryUIPlugin;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class ExtensionFileFilter
extends ViewerFilter {
    private Set<String> allowedExtensions = new HashSet<String>();
    private List<IFile> fileExclusions;

    public ExtensionFileFilter(IFile[] excludedFiles, String ... exts) {
        if (exts != null) {
            String[] stringArray = exts;
            int n = exts.length;
            int n2 = 0;
            while (n2 < n) {
                String ext = stringArray[n2];
                this.allowedExtensions.add(ext.toLowerCase());
                ++n2;
            }
        }
        this.fileExclusions = excludedFiles != null ? Arrays.asList(excludedFiles) : null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean select(Viewer viewer, Object parent, Object element) {
        if (element instanceof IFile) {
            if (this.fileExclusions == null) return this.isAllowedPath(((IFile)element).getFullPath());
            if (!this.fileExclusions.contains(element)) return this.isAllowedPath(((IFile)element).getFullPath());
            return false;
        }
        if (!(element instanceof IContainer)) return false;
        try {
            IResource[] resources = ((IContainer)element).members();
            int i = 0;
            while (true) {
                if (i >= resources.length) {
                    return false;
                }
                if (this.select(viewer, parent, resources[i])) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            Status status = new Status(4, StoryUIPlugin.getDefault().getID(), "", (Throwable)e);
            StoryUIPlugin.getDefault().getLog().log((IStatus)status);
        }
        return false;
    }

    public boolean isAllowedPath(IPath path) {
        if (this.allowedExtensions.isEmpty()) {
            return true;
        }
        String ext = path.getFileExtension();
        if (ext != null && ext.length() != 0) {
            ext = ext.toLowerCase();
            return this.allowedExtensions.contains(ext);
        }
        return false;
    }
}

