/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.actions.editor;

import edu.mit.story.ui.StoryUIMessages;
import edu.mit.story.ui.actions.generic.ResourceAction2;
import edu.mit.story.ui.editor.IHasStoryEditor;
import edu.mit.story.ui.editor.IStoryEditor;
import org.eclipse.ui.IPropertyListener;

public class ViewLayoutAction
extends ResourceAction2
implements IPropertyListener,
IHasStoryEditor {
    IStoryEditor editor;
    final IStoryEditor.ViewLayout viewState;

    public ViewLayoutAction(String prefix, IStoryEditor.ViewLayout state) {
        super(StoryUIMessages.getBundle(), prefix);
        this.viewState = state;
    }

    public void run() {
        if (this.getStoryEditor() != null) {
            this.getStoryEditor().setViewLayout(this.viewState);
        }
    }

    public void setStoryEditor(IStoryEditor newEditor) {
        if (this.editor == newEditor) {
            return;
        }
        if (this.editor != null) {
            this.editor.removePropertyListener(this);
        }
        this.editor = newEditor;
        if (this.editor != null) {
            this.editor.addPropertyListener(this);
        }
        this.setEnabled(this.editor != null);
    }

    public IStoryEditor getStoryEditor() {
        return this.editor;
    }

    public void propertyChanged(Object source, int propId) {
        if (source == this.getStoryEditor() & propId == IStoryEditor.PROP_VIEWLAYOUT) {
            this.update();
        }
    }

    public void update() {
        if (this.getStoryEditor() == null) {
            return;
        }
        if (this.getStoryEditor().getViewLayout() == this.viewState) {
            this.setChecked(true);
        } else {
            this.setChecked(false);
        }
    }

    public static class SetViewHorizontalAction
    extends ViewLayoutAction {
        public SetViewHorizontalAction() {
            super(StoryUIMessages.ACTION_LayoutHorizontal_prefix, IStoryEditor.ViewLayout.HORIZONTAL);
        }
    }

    public static class SetViewTabbedAction
    extends ViewLayoutAction {
        public SetViewTabbedAction() {
            super(StoryUIMessages.ACTION_LayoutTabbed_prefix, IStoryEditor.ViewLayout.TABBED);
        }
    }

    public static class SetViewVerticalAction
    extends ViewLayoutAction {
        public SetViewVerticalAction() {
            super(StoryUIMessages.ACTION_LayoutVertical_prefix, IStoryEditor.ViewLayout.VERTICAL);
        }
    }
}

