/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.event.model;

import edu.mit.parsing.core.model.ISegmentModel;
import edu.mit.parsing.core.model.ISegmentSetModel;
import edu.mit.parsing.core.model.SegmentSetModel;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.parsing.core.rep.token.TokenSegmentModel;
import edu.mit.semantics.core.rep.event.Aspect;
import edu.mit.semantics.core.rep.event.Event;
import edu.mit.semantics.core.rep.event.EventClass;
import edu.mit.semantics.core.rep.event.EventRep;
import edu.mit.semantics.core.rep.event.IEvent;
import edu.mit.semantics.core.rep.event.POS;
import edu.mit.semantics.core.rep.event.Tense;
import edu.mit.semantics.core.rep.event.model.IEventModel;
import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.datamodel.AbstractViewModel;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.ISegment;
import edu.mit.story.core.desc.ISegmentSet;
import edu.mit.story.core.desc.IStructuredData;
import edu.mit.story.core.desc.Segment;
import edu.mit.story.core.desc.SegmentSet;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.core.position.SimplePosition;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.core.validation.Message;
import java.util.Collection;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.jface.dialogs.IMessageProvider;

public class EventModel
extends AbstractViewModel
implements IEventModel,
ChangeListener {
    public static final Message unspecifiedClass = new Message("Please specify the event class", 3);
    public static final Message emptyEventMsg = new Message("The set of event tokens may not be empty", 3);
    public static final Message emptyHeadMsg = new Message("The set of head tokens may not be empty", 3);
    public static final Message headMustBeSubsetMsg = new Message("The set of head tokens contains tokens that are not contained in the full event marking", 3);
    private final IStoryModel model;
    private final ISegmentSetModel eventTokens;
    private final ISegmentSetModel headTokens;
    private final ISegmentModel polTokens;
    private final ISegmentModel cardTokens;
    private final ISegmentModel modeTokens;
    private IDesc loaded = null;
    private EventClass eventClass = this.getDefaultEventClass();
    private POS pos = this.getDefaultPOS();
    private Tense tense = this.getDefaultTense();
    private Aspect aspect = this.getDefaultAspect();
    private boolean polarity = this.getDefaultPolarity();
    private int cardinality = this.getDefaultCardinality();
    private boolean isModeSetEmpty = this.getDefaultSetEmpty();
    private boolean isCardSetEmpty = this.getDefaultSetEmpty();
    private boolean isPolrSetEmpty = this.getDefaultSetEmpty();

    public EventModel(IStoryModel model) {
        this(model, true);
    }

    public EventModel(IStoryModel model, boolean listen) {
        this.model = model;
        this.eventTokens = new SegmentSetModel(TokenRep.getInstance(), model, listen);
        this.headTokens = new SegmentSetModel(TokenRep.getInstance(), model, listen);
        this.polTokens = new TokenSegmentModel(model, listen);
        this.cardTokens = new TokenSegmentModel(model, listen);
        this.modeTokens = new TokenSegmentModel(model, listen);
        this.eventTokens.addChangeListener((ChangeListener)this);
        this.headTokens.addChangeListener((ChangeListener)this);
        this.polTokens.addChangeListener((ChangeListener)this);
        this.cardTokens.addChangeListener((ChangeListener)this);
        this.modeTokens.addChangeListener((ChangeListener)this);
    }

    public IStoryModel getStoryModel() {
        return this.model;
    }

    public ISegmentSet getEventTokens() {
        IHasPositionSet segs = this.eventTokens.getSegments();
        return segs.isEmpty() ? null : new SegmentSet((Collection)segs);
    }

    public ISegmentSetModel getEventModel() {
        return this.eventTokens;
    }

    public ISegmentSet getHeadTokens() {
        IHasPositionSet segs = this.headTokens.getSegments();
        return segs.isEmpty() ? null : new SegmentSet((Collection)segs);
    }

    public ISegmentSetModel getHeadModel() {
        return this.headTokens;
    }

    public EventClass getEventClass() {
        return this.eventClass;
    }

    public POS getPOS() {
        return this.pos;
    }

    public Tense getTense() {
        return this.tense;
    }

    public Aspect getAspect() {
        return this.aspect;
    }

    public boolean getPolarity() {
        return this.polarity;
    }

    public ISegment getPolarityTokens() {
        IDescSet ds = this.polTokens.getSegment();
        return ds.isEmpty() ? null : new Segment((IHasPosition)ds, ds.getRep(), this.getStoryModel().getData());
    }

    public ISegmentModel getPolarityModel() {
        return this.polTokens;
    }

    public int getCardinality() {
        return this.cardinality;
    }

    public ISegment getCardinalityTokens() {
        IDescSet ds = this.cardTokens.getSegment();
        return ds.isEmpty() ? null : new Segment((IHasPosition)ds, ds.getRep(), this.getStoryModel().getData());
    }

    public ISegmentModel getCardinalityModel() {
        return this.cardTokens;
    }

    public ISegment getModalityTokens() {
        IDescSet ds = this.modeTokens.getSegment();
        return ds.isEmpty() ? null : new Segment((IHasPosition)ds, ds.getRep(), this.getStoryModel().getData());
    }

    public ISegmentModel getModalityModel() {
        return this.modeTokens;
    }

    public boolean isModalityEmpty() {
        return this.isModeSetEmpty;
    }

    public boolean isCardinalityEmpty() {
        return this.isCardSetEmpty;
    }

    public boolean isPolarityEmpty() {
        return this.isPolrSetEmpty;
    }

    public void stateChanged(ChangeEvent e) {
        if (this.isModeSetEmpty && !this.modeTokens.getSegment().isEmpty()) {
            this.isModeSetEmpty = false;
        }
        if (this.isPolrSetEmpty && !this.polTokens.getSegment().isEmpty()) {
            this.isPolrSetEmpty = false;
        }
        if (this.isCardSetEmpty && !this.cardTokens.getSegment().isEmpty()) {
            this.isCardSetEmpty = false;
        }
        this.fireChanged();
    }

    public void setEventClass(EventClass newClass) {
        EventClass eventClass = newClass = newClass == null ? this.getDefaultEventClass() : newClass;
        if (this.eventClass == newClass) {
            return;
        }
        this.eventClass = newClass;
        this.fireChanged();
    }

    public void setPOS(POS newPOS) {
        POS pOS = newPOS = newPOS == null ? this.getDefaultPOS() : newPOS;
        if (this.pos == newPOS) {
            return;
        }
        this.pos = newPOS;
        this.fireChanged();
    }

    public void setTense(Tense newTense) {
        Tense tense = newTense = newTense == null ? this.getDefaultTense() : newTense;
        if (this.tense == newTense) {
            return;
        }
        this.tense = newTense;
        this.fireChanged();
    }

    public void setAspect(Aspect newAspect) {
        Aspect aspect = newAspect = newAspect == null ? this.getDefaultAspect() : newAspect;
        if (this.aspect == newAspect) {
            return;
        }
        this.aspect = newAspect;
        this.fireChanged();
    }

    public void setPolarity(boolean polarity) {
        if (this.polarity == polarity) {
            return;
        }
        this.polarity = polarity;
        this.fireChanged();
    }

    public void setCardinality(int newCardinality) {
        int n = newCardinality = newCardinality < 0 ? this.getDefaultCardinality() : newCardinality;
        if (this.cardinality == newCardinality) {
            return;
        }
        this.cardinality = newCardinality;
        this.fireChanged();
    }

    public IDesc getLoaded() {
        return this.loaded;
    }

    public void setLoaded(IDesc desc) {
        if (!EventRep.getInstance().isType((IHasRep)desc)) {
            throw new IllegalArgumentException();
        }
        this.loaded = desc;
        IEvent event = (IEvent)desc.getData();
        this.eventClass = event.getEventClass();
        this.eventTokens.setSegments((Collection)event.getEventTokens());
        this.headTokens.setSegments((Collection)event.getHeadTokens());
        this.pos = event.getPOS();
        this.tense = event.getTense();
        this.aspect = event.getAspect();
        this.polarity = event.getPolarity();
        this.polTokens.setSegment(event.getPolarityTokens() == null ? null : event.getPolarityTokens().getDescs());
        this.cardinality = event.getCardinality();
        this.cardTokens.setSegment(event.getCardinalityTokens() == null ? null : event.getCardinalityTokens().getDescs());
        this.modeTokens.setSegment(event.getModalityTokens() == null ? null : event.getModalityTokens().getDescs());
    }

    public void setModalityEmpty(boolean isModeSetEmpty) {
        if (this.isModeSetEmpty == isModeSetEmpty) {
            return;
        }
        this.isModeSetEmpty = isModeSetEmpty;
        this.fireChanged();
    }

    public void setCardinalityEmpty(boolean isCardSetEmpty) {
        if (this.isCardSetEmpty == isCardSetEmpty) {
            return;
        }
        this.isCardSetEmpty = isCardSetEmpty;
        this.fireChanged();
    }

    public void setPolarityEmpty(boolean isPolrSetEmpty) {
        if (this.isPolrSetEmpty == isPolrSetEmpty) {
            return;
        }
        this.isPolrSetEmpty = isPolrSetEmpty;
        this.fireChanged();
    }

    protected IMessageProvider calculateMessage() {
        if (this.eventClass == EventClass.UNSPECIFIED) {
            return unspecifiedClass;
        }
        if (this.eventTokens.isCleared()) {
            return emptyEventMsg;
        }
        if (this.headTokens.isCleared()) {
            return emptyHeadMsg;
        }
        if (!this.eventTokens.getDescs().containsAll((Collection)this.headTokens.getDescs())) {
            return headMustBeSubsetMsg;
        }
        return Message.NO_MESSAGE;
    }

    protected void internalClear() {
        this.loaded = null;
        this.eventClass = this.getDefaultEventClass();
        this.pos = this.getDefaultPOS();
        this.tense = this.getDefaultTense();
        this.aspect = this.getDefaultAspect();
        this.polarity = this.getDefaultPolarity();
        this.cardinality = this.getDefaultCardinality();
        this.isModeSetEmpty = this.getDefaultSetEmpty();
        this.isCardSetEmpty = this.getDefaultSetEmpty();
        this.isPolrSetEmpty = this.getDefaultSetEmpty();
        this.eventTokens.clear();
        this.headTokens.clear();
        this.polTokens.clear();
        this.cardTokens.clear();
        this.modeTokens.clear();
    }

    protected EventClass getDefaultEventClass() {
        return EventClass.UNSPECIFIED;
    }

    protected POS getDefaultPOS() {
        return POS.UNSPECIFIED;
    }

    protected Tense getDefaultTense() {
        return Tense.UNSPECIFIED;
    }

    protected Aspect getDefaultAspect() {
        return Aspect.UNSPECIFIED;
    }

    protected boolean getDefaultPolarity() {
        return true;
    }

    protected int getDefaultCardinality() {
        return 1;
    }

    protected boolean getDefaultSetEmpty() {
        return false;
    }

    public boolean isCleared() {
        if (this.eventClass != this.getDefaultEventClass()) {
            return false;
        }
        if (this.pos != this.getDefaultPOS()) {
            return false;
        }
        if (this.tense != this.getDefaultTense()) {
            return false;
        }
        if (this.aspect != this.getDefaultAspect()) {
            return false;
        }
        if (this.polarity != this.getDefaultPolarity()) {
            return false;
        }
        if (this.cardinality != this.getDefaultCardinality()) {
            return false;
        }
        if (!this.eventTokens.isCleared()) {
            return false;
        }
        if (!this.headTokens.isCleared()) {
            return false;
        }
        if (!this.cardTokens.isCleared()) {
            return false;
        }
        if (!this.polTokens.isCleared()) {
            return false;
        }
        if (!this.modeTokens.isCleared()) {
            return false;
        }
        if (this.isModeSetEmpty != this.getDefaultSetEmpty()) {
            return false;
        }
        if (this.isCardSetEmpty != this.getDefaultSetEmpty()) {
            return false;
        }
        return this.isPolrSetEmpty == this.getDefaultSetEmpty();
    }

    public IHasPosition getDisplayPosition() {
        ISegmentSet segs = this.getHeadTokens();
        return segs == null ? null : new SimplePosition((IHasPosition)segs);
    }

    public IHasPosition calculatePosition() {
        throw new UnsupportedOperationException();
    }

    public IStructuredData recalculate(IDesc container, IStoryModel model) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(IData tgtData, IAlignedStoryModel model) {
        throw new UnsupportedOperationException();
    }

    public void dispose() {
        this.eventTokens.dispose();
        this.headTokens.dispose();
        this.cardTokens.dispose();
        this.polTokens.dispose();
        this.modeTokens.dispose();
    }

    public IEvent toEvent() {
        return new Event(this.eventClass, this.getEventTokens(), this.getHeadTokens(), this.pos, this.tense, this.aspect, this.polarity, this.getPolarityTokens(), this.cardinality, this.getCardinalityTokens(), this.getModalityTokens());
    }
}

