/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.io.PrintFile;
import edu.stanford.nlp.maxent.CGRunner;
import edu.stanford.nlp.maxent.Problem;
import edu.stanford.nlp.tagger.maxent.CollectionTaggerOutputs;
import edu.stanford.nlp.tagger.maxent.Dictionary;
import edu.stanford.nlp.tagger.maxent.GlobalHolder;
import edu.stanford.nlp.tagger.maxent.LambdaSolveTagger;
import edu.stanford.nlp.tagger.maxent.TaggerExperiments;
import edu.stanford.nlp.tagger.maxent.TaggerFeatures;
import edu.stanford.nlp.tagger.maxent.TestSentence;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

public class TestClassifier {
    private String filename;
    private BufferedReader rf;
    private PrintFile pf;
    private int buffSize = 40;
    private int numRight;
    private int numWrong;
    private int unknownWords;
    private int numWrongUnknown;
    private int unAssigned;
    private int unAssignedUnKnown;
    private int numWrongUnknownT3;
    private int numWrongT3;
    private int numCorrectSentences;
    private int numSentences;
    static boolean writeUnknDict = false;
    static boolean writeWords = false;
    static boolean writeTopWords = false;
    static String[] arg_outputs = null;
    Dictionary wrongWords = new Dictionary();
    Dictionary unknownWordsDict = new Dictionary();

    public TestClassifier(String filename1, String saveRoot, String delimiter) throws Exception {
        int format = 0;
        format = 1;
        this.filename = filename1;
        this.test(format, saveRoot, delimiter);
    }

    public void test(int format, String saveRoot, String delimiter) throws Exception {
        if (format == 1) {
            this.test(saveRoot, delimiter);
        } else {
            BufferedReader in = new BufferedReader(new FileReader(this.filename));
            PrintFile pf1 = null;
            String s = null;
            if (writeWords) {
                this.pf = new PrintFile(saveRoot + ".words");
            }
            if (writeUnknDict) {
                pf1 = new PrintFile(saveRoot + ".un.dict");
            }
            GlobalHolder.tFeature.init();
            TestSentence ts = null;
            int sentNo = 0;
            while ((s = in.readLine()) != null) {
                ts = new TestSentence(GlobalHolder.prob, s, this.pf);
                if (writeUnknDict) {
                    ts.printUnknown(sentNo, pf1);
                }
                ++sentNo;
            }
            if (this.pf != null) {
                this.pf.close();
            }
            if (pf1 != null) {
                pf1.close();
            }
        }
    }

    public void test(String saveRoot, String delimiter) throws Exception {
        String s;
        String[] sentence = new String[1000];
        String[] tagsArr = new String[1000];
        int len = -1;
        this.numSentences = 0;
        String eosTag = "EOS";
        String eosWord = "EOS";
        int currentWord = 0;
        PrintFile pf1 = null;
        PrintFile pf3 = null;
        int index = 0;
        GlobalHolder.tFeature.init();
        System.out.println("classifier: initializing");
        this.rf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.filename), "UTF-8"));
        if (writeWords) {
            this.pf = new PrintFile(saveRoot + ".words");
        }
        if (writeUnknDict) {
            pf1 = new PrintFile(saveRoot + ".un.dict");
        }
        if (writeTopWords) {
            pf3 = new PrintFile(saveRoot + ".words.top");
        }
        System.out.println("classifier: reading test sentences from " + this.filename);
        while ((s = this.rf.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(s);
            while (st.hasMoreTokens()) {
                String t1;
                String w1;
                String token = st.nextToken();
                index = token.indexOf(delimiter);
                sentence[++len] = w1 = token.substring(0, index);
                tagsArr[len] = t1 = token.substring(index + 1);
            }
            sentence[++len] = eosWord;
            tagsArr[len] = eosTag;
            String[] testSent = new String[len + 1];
            String[] correctTags = new String[len + 1];
            for (int i = 0; i < len + 1; ++i) {
                testSent[i] = sentence[i];
                correctTags[i] = tagsArr[i];
            }
            TestSentence ts = new TestSentence(GlobalHolder.prob, testSent, correctTags, this.pf, this.wrongWords);
            if (writeUnknDict) {
                ts.printUnknown(this.numSentences, pf1);
            }
            if (writeTopWords) {
                ts.printTop(pf3);
            }
            this.numWrong += ts.numWrong;
            this.numRight += ts.numRight;
            this.unknownWords += ts.numUnknown;
            this.numWrongUnknown += ts.numWrongUnknown;
            this.numWrongUnknownT3 += ts.numWrongUnknownT3;
            this.numWrongT3 += ts.numWrongT3;
            this.unAssigned += ts.numUnassigned;
            this.unAssignedUnKnown += ts.numUnknownUnassigned;
            if (ts.numWrong == 0) {
                ++this.numCorrectSentences;
            }
            System.out.println("Sentence number: " + this.numSentences + "; length " + len + "; correct: " + ts.numRight + "; wrong: " + ts.numWrong + "; unknown wrong: " + ts.numWrongUnknown);
            System.out.println("  Total tags correct: " + this.numRight + "; wrong: " + this.numWrong + "; unknown wrong: " + this.numWrongUnknown);
            currentWord = currentWord + len + 1;
            len = -1;
            ++this.numSentences;
        }
        this.rf.close();
        if (this.pf != null) {
            this.pf.close();
        }
        if (pf1 != null) {
            pf1.close();
        }
        if (pf3 != null) {
            pf3.close();
        }
    }

    public static void iterate(String filename) {
        GlobalHolder.init();
        GlobalHolder.read_prev(filename + ".holder");
        GlobalHolder.prob.ImprovedIterative();
        boolean b = GlobalHolder.prob.checkCorrectness();
        if (b) {
            System.out.println("model is correct");
        }
        GlobalHolder.save_after(filename + ".holder");
    }

    public static void saveModel(String filename1, String modelPrefix, int iterations, String[] args_output, boolean cg, String lang, String arch, String delimiter) throws Exception {
        LambdaSolveTagger prob;
        TaggerExperiments samples;
        GlobalHolder.init(lang, arch);
        if (new File(modelPrefix + ".holder").exists()) {
            throw new RuntimeException("model file " + modelPrefix + ".holder already exists, not overwriting...");
        }
        GlobalHolder.domain = samples = new TaggerExperiments(filename1, args_output, delimiter);
        TaggerFeatures feats = new TaggerFeatures();
        feats = TaggerExperiments.feats;
        System.out.println("Samples from " + filename1);
        System.out.println(samples);
        System.out.println("Before" + feats.size());
        Problem p = new Problem(samples, feats);
        GlobalHolder.prob = prob = new LambdaSolveTagger(p, 1.0E-4, 1.0E-5);
        GlobalHolder.save_prev(modelPrefix + ".holder");
        Runtime rt = Runtime.getRuntime();
        System.out.println(" before " + rt.freeMemory());
        rt.gc();
        System.out.println(" after " + rt.freeMemory());
        if (cg) {
            CGRunner runner = new CGRunner(prob, modelPrefix);
            runner.solve();
        } else {
            prob.ImprovedIterative(iterations);
        }
        boolean b = prob.checkCorrectness();
        if (b) {
            System.out.println("model is correct");
        }
        GlobalHolder.save_after(modelPrefix + ".holder");
    }

    public static void save_param(String filename, String delimiter) throws Exception {
        LambdaSolveTagger prob;
        TaggerExperiments samples;
        GlobalHolder.init();
        GlobalHolder.domain = samples = new TaggerExperiments(filename, null, delimiter);
        TaggerFeatures feats = new TaggerFeatures();
        feats = TaggerExperiments.feats;
        System.out.println("Before" + feats.size());
        Problem p = new Problem(samples, feats);
        System.out.println(" Entering lambda solve ");
        GlobalHolder.prob = prob = new LambdaSolveTagger(p, 1.0E-4, 1.0E-5);
        GlobalHolder.save_prev(filename + ".holder");
        Runtime rt = Runtime.getRuntime();
        System.out.println(" before " + rt.freeMemory());
        GlobalHolder.release_mem();
        rt.gc();
        System.out.println(" after " + rt.freeMemory());
        GlobalHolder.prob = prob;
        boolean b = prob.checkCorrectness();
        if (b) {
            System.out.println("model is correct");
        }
        GlobalHolder.save_after(filename + ".holder");
    }

    public static void expandModel(String filename, String oldModelFile, int iters, String delimiter) throws Exception {
        LambdaSolveTagger prob;
        TaggerExperiments samples;
        GlobalHolder.init();
        GlobalHolder.domain = samples = new TaggerExperiments(filename, arg_outputs, delimiter);
        TaggerFeatures feats = new TaggerFeatures();
        feats = TaggerExperiments.feats;
        System.out.println("Before" + feats.size());
        Problem p = new Problem(samples, feats);
        GlobalHolder.prob = prob = new LambdaSolveTagger(p, 1.0E-4, 1.0E-5);
        GlobalHolder.save_prev(filename + ".holder");
        Runtime rt = Runtime.getRuntime();
        System.out.println(" before " + rt.freeMemory());
        GlobalHolder.release_mem();
        rt.gc();
        System.out.println(" after " + rt.freeMemory());
        prob.readOldLambdas(filename, oldModelFile);
        GlobalHolder.prob.ImprovedIterative(iters);
        boolean b = prob.checkCorrectness();
        if (b) {
            System.out.println("model is correct");
        } else {
            System.out.println(" model is not correct");
        }
        GlobalHolder.save_after(filename + ".holder");
    }

    public static void testModel(String filename, String modelPrefix, String debugPrefix, String[] args_output, String delimiter) throws Exception {
        System.out.println("initializing global thing");
        GlobalHolder.init();
        System.out.println("reading model " + modelPrefix);
        GlobalHolder.read(modelPrefix + ".holder");
        if (args_output != null) {
            GlobalHolder.collectionTaggers = new CollectionTaggerOutputs(args_output);
        }
        CollectionTaggerOutputs.baseToken -= GlobalHolder.pairs.getSize();
        System.out.println("making testclassifier");
        TestClassifier tC = new TestClassifier(filename, debugPrefix, delimiter);
        System.out.println("Results on " + (tC.numRight + tC.numWrong) + " words and " + tC.numSentences + " sentences. ");
        System.out.printf("Total sentences right: %d (%f%%); wrong: %d (%f%%).\n", tC.numCorrectSentences, (double)tC.numCorrectSentences * 100.0 / (double)tC.numSentences, tC.numSentences - tC.numCorrectSentences, (double)(tC.numSentences - tC.numCorrectSentences) * 100.0 / (double)tC.numSentences);
        System.out.printf("Total tags right: %d (%f%%); wrong: %d (%f%%).\n", tC.numRight, (double)tC.numRight * 100.0 / (double)(tC.numRight + tC.numWrong), tC.numWrong, (double)tC.numWrong * 100.0 / (double)(tC.numRight + tC.numWrong));
        System.out.printf("Unknown words (%d) right: %d (%f%%); wrong: %d (%f%%).\n", tC.unknownWords, tC.unknownWords - tC.numWrongUnknown, 100.0 - (double)tC.numWrongUnknown * 100.0 / (double)tC.unknownWords, tC.numWrongUnknown, (double)tC.numWrongUnknown * 100.0 / (double)tC.unknownWords);
    }
}

