/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.parser.lexparser.BaseLexicon;
import edu.stanford.nlp.parser.lexparser.ChineseUnknownWordModel;
import edu.stanford.nlp.parser.lexparser.IntTaggedWord;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.lexparser.RandomWalk;
import edu.stanford.nlp.trees.Tree;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChineseLexicon
extends BaseLexicon {
    private static final boolean useRandomWalk = false;
    public static boolean useCharBasedUnknownWordModel = false;
    public static boolean useGoodTuringUnknownWordModel = false;
    private ChineseUnknownWordModel unknown = new ChineseUnknownWordModel();
    private static final int STEPS = 1;
    private RandomWalk probRandomWalk;

    public ChineseLexicon(Options.LexOptions op) {
        super(op);
        if (useGoodTuringUnknownWordModel) {
            this.unknown.useGoodTuring();
        }
        this.unknown.useUnicodeType = op.useUnicodeType;
    }

    @Override
    public void train(Collection<Tree> trees) {
        super.train(trees);
        this.unknown.train(trees);
    }

    @Override
    public float score(IntTaggedWord iTW, int loc) {
        boolean seen;
        double c_W = this.seenCounter.getCount(iTW);
        boolean bl = seen = c_W > 0.0;
        if (seen) {
            return super.score(iTW, loc);
        }
        double score = this.unknown.score(iTW);
        return (float)score;
    }

    private double scoreRandomWalk(IntTaggedWord itw) {
        TaggedWord tw = itw.toTaggedWord();
        String word = tw.value();
        String tag = tw.tag();
        return this.probRandomWalk.score(tag, word);
    }
}

