/* Filename: ReferentDetailsPage.java
 * Creator: M.A. Finlayson
 * Format: Java 2 v1.6.0
 * Date created: Sep 22, 2009
 */
package nil.ucm.indications2.ui.helpers;

import nil.ucm.indications2.core.rep.indication.IndicationRep;
import nil.ucm.indications2.ui.content.IndicationContentProvider;
import nil.ucm.indications2.ui.label.IndicationLabelProvider;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;

import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.model.change.IModelListener;
import edu.mit.story.core.model.change.RemoveDescriptionsChange;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.ui.actions.ActionUtils;
import edu.mit.story.ui.actions.DescActionUtils;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.actions.generic.CollapseAllAction;
import edu.mit.story.ui.actions.generic.DeleteAction;
import edu.mit.story.ui.actions.generic.ExpandAllAction;
import edu.mit.story.ui.actions.groups.StoryEditorUndoRedoActionGroup;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.helpers.HelperPage;
import edu.mit.story.ui.helpers.IDetailsPage;
import edu.mit.story.ui.viewers.StoryElementComparer;

/** 
 * TODO: Write comment
 *
 * @author M.A. Finlayson
 * @version $Rev$, $LastChangedDate$
 * @since edu.mit.discourse.ui 1.0.0
 */
public class IndicationsDetailsPage extends HelperPage implements IDetailsPage, IAdaptable, IModelListener {
	
	public static final String ID = IndicationsDetailsPage.class.getCanonicalName();
	
	// widgets
	protected TreeViewer treeViewer;
	
	// actions
	IAction deleteAction;
	IAction collapseAction;
	IAction expandAction;
	ActionGroup undoRedoActions;
	
	public TreeViewer getTreeViewer(){
		return treeViewer;
	}

	/* 
	 * (non-Javadoc) @see org.eclipse.ui.part.IPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createControl(Composite parent) {
		
        treeViewer = new TreeViewer(parent, SWT.MULTI | SWT.H_SCROLL | SWT.V_SCROLL);
        treeViewer.setComparer(StoryElementComparer.getInstance());
        treeViewer.setAutoExpandLevel(2);
        treeViewer.setContentProvider(new IndicationContentProvider(getStoryEditor()));
        treeViewer.setLabelProvider(new IndicationLabelProvider(getStoryEditor()));
        treeViewer.setInput(getStoryEditor());
        setControl(treeViewer.getTree());
        
		// create actions
		deleteAction = new DeleteElementAction();
		undoRedoActions = new StoryEditorUndoRedoActionGroup(getStoryEditor());
		collapseAction = new CollapseAllAction(treeViewer, 2);
		expandAction = new ExpandAllAction(treeViewer);
		
		// create popup menu manager
		final MenuManager manager = new MenuManager();
		ActionUtils.createPopupGroups(manager);
		undoRedoActions.fillContextMenu(manager);
		manager.appendToGroup(ITextEditorActionConstants.GROUP_EDIT, deleteAction);
		Menu menu = manager.createContextMenu(getControl());
		treeViewer.getTree().setMenu(menu);
		getSite().registerContextMenu(ID + ".popupMenu", manager, treeViewer);
	}

	/* 
	 * (non-Javadoc) @see org.eclipse.ui.part.IPage#setActionBars(org.eclipse.ui.IActionBars)
	 */
	public void setActionBars(IActionBars actionBars) {
		actionBars.getToolBarManager().insertBefore("linking", collapseAction);
		actionBars.getToolBarManager().insertBefore(collapseAction.getId(), expandAction);

		actionBars.setGlobalActionHandler(collapseAction.getActionDefinitionId(), collapseAction);
		actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), deleteAction);
		undoRedoActions.fillActionBars(actionBars);
		
		actionBars.updateActionBars();
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.ui.editor.IHasStoryEditor#setStoryEditor(edu.mit.story.ui.editor.IStoryEditor)
	 */
	public void setStoryEditor(IStoryEditor newEditor) {
		super.setStoryEditor(newEditor);
		getStoryEditor().getStoryModel().addModelListener(this);
	}
	
	/* 
	 * (non-Javadoc) @see edu.mit.story.core.model.change.IModelListener#modelChanged(edu.mit.story.core.model.change.StoryChangeEvent)
	 */
	
	public void modelChanged(StoryChangeEvent e) {
		if(treeViewer == null) 
			return;
		if(!e.affects(IndicationRep.getInstance()))
			return;
		
		treeViewer.refresh();
	}
	
	/* 
	 * (non-Javadoc) @see org.eclipse.core.runtime.IAdaptable#getAdapter(java.lang.Class)
	 */
	
	@SuppressWarnings("unchecked")
	public Object getAdapter(Class adapter) {
		// return requests for selection providers
		if(adapter == ISelectionProvider.class) return treeViewer;
		if(adapter == IPostSelectionProvider.class) return treeViewer;
		// otherwise defer to platform's adapter manager
		return Platform.getAdapterManager().getAdapter(this, adapter);
	}

	/* 
	 * (non-Javadoc) @see org.eclipse.ui.part.IPage#dispose()
	 */
	
	public void dispose() {
		getStoryEditor().getStoryModel().removeModelListener(this);
		super.dispose();
	}
	
	/** 
	 * TODO: Write comment
	 *
	 * @author M.A. Finlayson
	 * @version $Rev$, $LastChangedDate$
	 * @since edu.mit.discourse.ui 1.0.0
	 */
	protected class DeleteElementAction extends DeleteAction implements ISelectionChangedListener {
	
		/**
		 * TODO: Write comment
		 *
		 * @since edu.mit.discourse.ui 1.0.0
		 */
		public DeleteElementAction() {
			treeViewer.addSelectionChangedListener(this);
		}
	
		/* (non-Javadoc) @see edu.mit.story.ui.actions.generic.DeleteAction#doDelete() */
		
		protected void doDelete() {
			
			ISelection sel = treeViewer.getSelection();
			
			// we have selected a description
			IDesc desc = SelectionUtils.extractSingle(sel, IDesc.class);
			if (desc != null) {
				getStoryEditor().getStoryModel().applyChange(this, new RemoveDescriptionsChange(desc), false);
				return;
			}
		}
	
		/* 
		 * (non-Javadoc) @see org.eclipse.jface.viewers.ISelectionChangedListener#selectionChanged(org.eclipse.jface.viewers.SelectionChangedEvent)
		 */
		
		public void selectionChanged(SelectionChangedEvent event) {
			
			ISelection sel = treeViewer.getSelection();
			
			// if referent is selected
			IDesc desc = SelectionUtils.extractSingle(sel, IDesc.class);
			if (desc != null){
				setEnabled(DescActionUtils.canDelete(desc, getStoryEditor().getStoryModel()));
				return;
			}

			setEnabled(false);
		}
	}
	

}
