/* Filename: CalculateAgreementHandler.java
 * Creator: M.A. Finlayson
 * Format: Java 2 v1.6.0
 * Date created: Feb 4, 2010
 */
package nil.ucm.indications2.ui.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import nil.ucm.indications2.ui.agreement.AgreeResult;
import nil.ucm.indications2.ui.agreement.IOverallAgreeResult;
import nil.ucm.indications2.ui.agreement.AgreementCalculator2;
import nil.ucm.indications2.ui.agreement.OverallAgreeResult;
import nil.ucm.indications2.ui.dialogs.SelectResourcesDialog;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

import edu.mit.story.core.measure.IResult;

/** 
 * TODO: Write comment
 *
 * @author M.A. Finlayson
 * @version $Rev$, $LastChangedDate$
 * @since nil.ucm.indications2.ui 1.0.0
 */
public class CalculateAgreementHandler extends AbstractHandler {

	/* 
	 * (non-Javadoc) @see org.eclipse.core.commands.IHandler#execute(org.eclipse.core.commands.ExecutionEvent)
	 */
	public Object execute(ExecutionEvent event) throws ExecutionException {

		// extract active shell
		Shell shell = HandlerUtil.getActiveShell(event);
		if(shell == null) return null;
		
		// prompt user for projects
		SelectResourcesDialog dialog = new SelectResourcesDialog(shell, IResource.PROJECT | IResource.FOLDER | IResource.FILE);
		dialog.setBlockOnOpen(true);
		dialog.setTitle("Calculate Agreement");
		int result = dialog.open();
		if(result == Dialog.CANCEL) return null;
		
		// get the selected projects
		IResource one = dialog.getResourceOne();
		IResource two = dialog.getResourceTwo();
		if(one == null || two == null) return null;
		
		// schedule calculation
		CalculationJob job = new CalculationJob(one, two);
		job.schedule();
		
		// must return null
		return null;
	}
	
	protected class CalculationJob extends Job {
		
		private final IResource one;
		private final IResource two;

		/**
		 * TODO: Write comment
		 *
		 * @param name
		 * @since nil.ucm.indications2.ui 1.0.0
		 */
		public CalculationJob(IResource one, IResource two) {
			super("Calculate agreement between " + one.getName() + " and " + two.getName());
			this.one = one;
			this.two = two;
			setPriority(LONG);
			setRule(one);
		}

		/* 
		 * (non-Javadoc) @see org.eclipse.core.runtime.jobs.Job#run(org.eclipse.core.runtime.IProgressMonitor)
		 */
		@Override
		protected IStatus run(IProgressMonitor monitor) {
			AgreementCalculator2 calc = new AgreementCalculator2();
			List<IResult> results = calc.calculate(one, two, monitor);
			
			results = new ArrayList<IResult>(results);
			Collections.sort(results, new Comparator<IResult>(){
				public int compare(IResult r1, IResult r2) {
					return r1.getTarget().getName().compareTo(r2.getTarget().getName());
				}});
			
			boolean notPrintedYet = true;
			System.out.println(AgreeResult.getHeaders(true));
			for(IResult r : results){
				if(r instanceof IOverallAgreeResult && notPrintedYet) {
					System.out.println(OverallAgreeResult.getHeaders(true));
					notPrintedYet = false;
				}
				System.out.println(r.toString(true));
			}
			return Status.OK_STATUS;
		}
		
	}


	
	
}
