/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jwi.item;

import edu.mit.jwi.item.IExceptionEntryProxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionEntryProxy
implements IExceptionEntryProxy {
    final String fSurface;
    final List<String> fRoots;
    private static String prefix = "EXC-";
    private static String rightBracket = "[";
    private static String leftBracket = "]";
    private static String comma = ", ";

    public ExceptionEntryProxy(IExceptionEntryProxy proxy) {
        this.fSurface = proxy.getSurfaceForm();
        this.fRoots = proxy.getRootForms();
    }

    public ExceptionEntryProxy(String surfaceForm, String ... rootForms) {
        if (surfaceForm == null) {
            throw new NullPointerException();
        }
        for (String form : rootForms) {
            if (form != null && form.length() != 0) continue;
            throw new IllegalArgumentException();
        }
        this.fSurface = surfaceForm;
        this.fRoots = Collections.unmodifiableList(Arrays.asList(rootForms));
    }

    @Override
    public String getSurfaceForm() {
        return this.fSurface;
    }

    @Override
    public List<String> getRootForms() {
        return this.fRoots;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(prefix);
        sb.append(this.fSurface);
        sb.append(rightBracket);
        Iterator<String> i = this.fRoots.iterator();
        while (i.hasNext()) {
            sb.append(i.next());
            if (!i.hasNext()) continue;
            sb.append(comma);
        }
        sb.append(leftBracket);
        return sb.toString();
    }
}

