/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.util;

import edu.mit.story.core.util.IUtilityClass;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public final class LogUtils
implements IUtilityClass {
    private LogUtils() {
    }

    public static void logInfo(Plugin plugin, String msg) {
        LogUtils.log(plugin, msg, 1);
    }

    public static void logInfo(Plugin plugin, Throwable t) {
        LogUtils.log(plugin, t, 1);
    }

    public static void logInfo(Plugin plugin, Throwable t, String msg) {
        LogUtils.log(plugin, t, msg, 1);
    }

    public static void logWarning(Plugin plugin, String msg) {
        LogUtils.log(plugin, msg, 2);
    }

    public static void logWarning(Plugin plugin, Throwable t) {
        LogUtils.log(plugin, t, 2);
    }

    public static void logWarning(Plugin plugin, Throwable t, String msg) {
        LogUtils.log(plugin, t, msg, 2);
    }

    public static void logError(Plugin plugin, String msg) {
        LogUtils.log(plugin, msg, 4);
    }

    public static void logError(Plugin plugin, Throwable t) {
        LogUtils.log(plugin, t, 4);
    }

    public static void logError(Plugin plugin, Throwable t, String msg) {
        LogUtils.log(plugin, t, msg, 4);
    }

    private static void log(Plugin plugin, Throwable t, int severity) {
        if (plugin == null) {
            return;
        }
        Status status = new Status(severity, plugin.getBundle().getSymbolicName(), t.getLocalizedMessage(), t);
        plugin.getLog().log((IStatus)status);
    }

    private static void log(Plugin plugin, String msg, int severity) {
        if (plugin == null) {
            return;
        }
        Status status = new Status(severity, plugin.getBundle().getSymbolicName(), msg, null);
        plugin.getLog().log((IStatus)status);
    }

    private static void log(Plugin plugin, Throwable t, String msg, int severity) {
        if (plugin == null) {
            return;
        }
        Status status = new Status(severity, plugin.getBundle().getSymbolicName(), msg, t);
        plugin.getLog().log((IStatus)status);
    }

    public static void logStatus(Plugin plugin, IStatus status) {
        if (plugin == null || status == null) {
            return;
        }
        plugin.getLog().log(status);
    }
}

