/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.model;

import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.factory.IDescFactory;
import edu.mit.story.core.meta.IMetaDataSet;
import edu.mit.story.core.meta.IMetaDesc;
import edu.mit.story.core.meta.IMetaRep;
import edu.mit.story.core.meta.MetaDataMap;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.property.IConfiguration;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.util.IHasVersion;
import edu.mit.story.core.util.IObjectExporter;
import edu.mit.story.core.util.XMLUtils;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoryModelExporter
implements IObjectExporter<IStoryModel> {
    public static final String TAG_STORY = "story";
    public static final String TAG_REPRESENTATION = "rep";
    public static final String TAG_META_REPRESENTATION = "metaRep";
    public static final String TAG_FACTORY = "factory";
    public static final String TAG_DESCRIPTION = "desc";
    public static final String TAG_META_DESCRIPTION = "metaDesc";
    public static final String TAG_PARAMETER = "param";
    public static final String ATTR_ID = "id";
    public static final String ATTR_OFFSET = "off";
    public static final String ATTR_LENGTH = "len";
    public static final String ATTR_VERSION = "ver";
    public static final String ATTR_USER = "user";
    public static final String ATTR_REP_ID = "repID";
    public static final String ATTR_DESC_ID = "descID";
    private static StoryModelExporter instance = null;

    public static StoryModelExporter getInstance() {
        if (instance == null) {
            instance = new StoryModelExporter();
        }
        return instance;
    }

    protected StoryModelExporter() {
    }

    @Override
    public Document exportToXML(IStoryModel model) {
        Element repNode;
        if (model == null) {
            throw new NullPointerException();
        }
        Document doc = XMLUtils.createEmptyDocument(TAG_STORY);
        Element headNode = (Element)doc.getElementsByTagName(TAG_STORY).item(0);
        MetaDataMap metadata = new MetaDataMap();
        metadata.addAllDescs(model.getData().getMetadata());
        for (IRep rep : model.getSupported()) {
            repNode = this.exportRep(headNode, rep, model.getData().getConfiguration(rep), doc);
            if (repNode == null) continue;
            this.exportFactory(repNode, model.getFactory(rep), doc);
            for (Comparable desc : model.getData().getDescriptions(rep)) {
                this.exportDesc(repNode, (IDesc)desc, doc);
                metadata.addAllDescs(desc.getMetaData());
            }
        }
        for (IMetaDataSet set : metadata.values()) {
            repNode = this.exportMetaRep(headNode, set.getMetaRep(), doc);
            if (repNode == null) continue;
            for (Comparable desc : set) {
                this.exportMetaDesc(repNode, (IMetaDesc<?>)desc, doc);
            }
        }
        doc.normalizeDocument();
        return doc;
    }

    public Element exportRep(Node parent, IRep rep, IConfiguration config, Document doc) {
        Element node = doc.createElement(TAG_REPRESENTATION);
        parent.appendChild(node);
        node.setAttribute(ATTR_ID, rep.getID());
        if (!rep.getVersion().equals((Object)IHasVersion.v1)) {
            node.setAttribute(ATTR_VERSION, rep.getVersion().toString());
        }
        this.exportConfig(node, config, doc);
        return node;
    }

    public void exportConfig(Node parent, IConfiguration config, Document doc) {
        if (config == null) {
            return;
        }
        for (Map.Entry entry : config.entrySet()) {
            Element node = doc.createElement(TAG_PARAMETER);
            parent.appendChild(node);
            node.setAttribute((String)entry.getKey(), (String)entry.getValue());
            this.exportConfig(node, config.getConfiguration((String)entry.getKey()), doc);
        }
    }

    public Element exportFactory(Node parent, IDescFactory factory, Document doc) {
        if (factory == null) {
            return null;
        }
        Element node = doc.createElement(TAG_FACTORY);
        parent.appendChild(node);
        node.setAttribute(ATTR_ID, factory.getID());
        this.exportConfig(node, factory.getConfiguration(), doc);
        return node;
    }

    public Element exportDesc(Node parent, IDesc desc, Document doc) {
        if (desc == null) {
            return null;
        }
        Element node = doc.createElement(TAG_DESCRIPTION);
        parent.appendChild(node);
        node.setAttribute(ATTR_ID, Long.toString(desc.getID()));
        node.setAttribute(ATTR_OFFSET, Integer.toString(desc.getOffset()));
        node.setAttribute(ATTR_LENGTH, Integer.toString(desc.getLength()));
        node.setTextContent(desc.getDataString());
        return node;
    }

    public Element exportMetaRep(Node parent, IMetaRep<?> rep, Document doc) {
        if (rep == null) {
            return null;
        }
        Element node = doc.createElement(TAG_META_REPRESENTATION);
        parent.appendChild(node);
        node.setAttribute(ATTR_ID, rep.getID());
        return node;
    }

    public Element exportMetaDesc(Node parent, IMetaDesc<?> desc, Document doc) {
        if (desc == null) {
            return null;
        }
        Element node = doc.createElement(TAG_META_DESCRIPTION);
        parent.appendChild(node);
        node.setAttribute(ATTR_REP_ID, desc.getRep().getID());
        if (desc.getDescriptionID() > -1L) {
            node.setAttribute(ATTR_DESC_ID, Long.toString(desc.getDescriptionID()));
        }
        node.setTextContent(desc.getSerializedData());
        return null;
    }
}

