/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.align;

import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.align.IDescMap;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.desc.ImmutableDescSet;
import edu.mit.story.core.desc.factory.IDescFactory;
import edu.mit.story.core.meta.IMetaDataMap;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.model.change.IModelListener;
import edu.mit.story.core.property.IConfigDescriptor;
import edu.mit.story.core.property.IConfiguration;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;
import edu.mit.story.core.rep.RepSet;
import edu.mit.story.core.rep.UnsupportedRepException;
import edu.mit.story.core.rep.character.IAlignedText;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlignedStoryModel
implements IAlignedStoryModel {
    private static final long serialVersionUID = 1090602206476669755L;
    private final String srcName;
    private final String tgtName;
    private final IStoryModel srcModel;
    private final IStoryModel tgtModel;
    private final IAlignedText alignment;
    private final Map<IRep, IDescMap> descMaps;
    private final Map<IRep, IDescSet> targetDescSets;
    private final Map<IRep, IConfiguration> configMap;
    private final IStoryData data;

    public AlignedStoryModel(String srcName, String tgtName, IStoryModel srcModel, IStoryModel tgtModel, IAlignedText alignment) {
        if (alignment == null) {
            throw new NullPointerException();
        }
        if (srcModel == null) {
            throw new NullPointerException();
        }
        if (tgtModel == null) {
            throw new NullPointerException();
        }
        this.srcName = srcName;
        this.tgtName = tgtName;
        this.srcModel = srcModel;
        this.tgtModel = tgtModel;
        this.alignment = alignment;
        this.descMaps = new HashMap<IRep, IDescMap>();
        this.targetDescSets = new HashMap<IRep, IDescSet>();
        this.configMap = new HashMap<IRep, IConfiguration>();
        this.data = new AlignedStoryData();
    }

    @Override
    public String getSourceName() {
        return this.srcName;
    }

    @Override
    public String getTargetName() {
        return this.tgtName;
    }

    @Override
    public IStoryModel getSourceModel() {
        return this.srcModel;
    }

    @Override
    public IStoryModel getTargetModel() {
        return this.tgtModel;
    }

    @Override
    public IAlignedText getAlignedText() {
        return this.alignment;
    }

    @Override
    public IDescMap get(IRep rep) {
        return this.descMaps.get(rep);
    }

    @Override
    public void put(IDescMap map, IConfiguration config) {
        this.descMaps.put(map.getRep(), map);
        this.targetDescSets.put(map.getRep(), new AlignedDescSet(map));
        IConfigDescriptor desc = map.getRep().getConfigurationDescriptor();
        if (desc != null) {
            this.configMap.put(map.getRep(), desc.createDefault());
        }
        if (config != null) {
            this.getData().setConfiguration(config);
        }
    }

    @Override
    public IStoryData getData() {
        return this.data;
    }

    @Override
    public boolean supports(IRep rep) {
        return this.data.supports(rep);
    }

    @Override
    public void addModelListener(IModelListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IDescFactory getFactory(IRep rep) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IRep getPrimary() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListenerList getProviderChangeListeners() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeModelListener(IModelListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getImplementationCode() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getImplementationName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSerializedData() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IRepSet getSupported() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<IRep> repIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int repSize() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsAll(Collection<? extends IRep> reps) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void init() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isInitialized() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dispose() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getLength() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getRightOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getNextID() {
        throw new UnsupportedOperationException();
    }

    public Object getAdapter(Class adapter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getCorpus() {
        return null;
    }

    protected class AlignedDescSet
    extends ImmutableDescSet {
        private final IDescMap descMap;
        private static final long serialVersionUID = -4279738194125131291L;

        public AlignedDescSet(IDescMap descMap) {
            super(descMap.getTarget());
            this.descMap = descMap;
        }

        public IDesc getDescription(long id) {
            return this.descMap.getDescription(id);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AlignedStoryData
    implements IStoryData {
        private static final long serialVersionUID = 7189240118718342954L;

        protected AlignedStoryData() {
        }

        @Override
        public IDesc getDescription(long id) {
            for (IDescMap map : AlignedStoryModel.this.descMaps.values()) {
                IDesc result = map.getDescription(id);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        @Override
        public IDescSet getDescriptions(IRep rep) {
            if (!this.supports(rep)) {
                throw new UnsupportedRepException(rep);
            }
            return (IDescSet)AlignedStoryModel.this.targetDescSets.get(rep);
        }

        @Override
        public boolean supports(IRep rep) {
            return AlignedStoryModel.this.descMaps.containsKey(rep);
        }

        @Override
        public IConfiguration getConfiguration(IRep rep) {
            return (IConfiguration)AlignedStoryModel.this.configMap.get(rep);
        }

        @Override
        public void setConfiguration(IConfiguration newConfig) {
            if (newConfig == null) {
                return;
            }
            IRep rep = StoryPlugin.getDefault().getRepManager().getRep(newConfig.getID());
            IConfigDescriptor desc = rep.getConfigurationDescriptor();
            if (desc == null) {
                return;
            }
            if (desc.validate(newConfig)) {
                IConfiguration config = (IConfiguration)AlignedStoryModel.this.configMap.get(rep);
                if (config == null) {
                    config = desc.createDefault();
                    AlignedStoryModel.this.configMap.put(rep, config);
                }
                config.configure(newConfig);
            }
        }

        @Override
        public Iterator<IRep> repIterator() {
            return AlignedStoryModel.this.descMaps.keySet().iterator();
        }

        @Override
        public IRepSet getSupported() {
            return new RepSet(AlignedStoryModel.this.descMaps.keySet());
        }

        @Override
        public int repSize() {
            return AlignedStoryModel.this.descMaps.keySet().size();
        }

        @Override
        public boolean supportsAll(Collection<? extends IRep> reps) {
            return AlignedStoryModel.this.descMaps.keySet().containsAll(reps);
        }

        @Override
        public int size(IRep target) {
            throw new UnsupportedOperationException();
        }

        @Override
        public IMetaDataMap getMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<IDescSet> descSetIterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(IDesc o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends IDesc> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<IDesc> iterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object[] toArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getImplementationCode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getImplementationName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSerializedData() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getLength() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getOffset() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getRightOffset() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAllSupport(Collection<? extends IRep> reps) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addSupport(IRep rep) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAllSupport(Collection<? extends IRep> reps) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeSupport(IRep rep) {
            throw new UnsupportedOperationException();
        }

        public Object getAdapter(Class adapter) {
            throw new UnsupportedOperationException();
        }
    }
}

