/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.resources;

import java.io.InputStream;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.tigris.subversion.subclipse.core.ISVNLocalFile;
import org.tigris.subversion.subclipse.core.ISVNLocalFolder;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteFolder;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.Policy;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.SVNStatus;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.core.client.PeekStatusCommand;
import org.tigris.subversion.subclipse.core.commands.CheckoutCommand;
import org.tigris.subversion.subclipse.core.commands.ShareProjectCommand;
import org.tigris.subversion.subclipse.core.resources.LocalFile;
import org.tigris.subversion.subclipse.core.resources.LocalFolder;
import org.tigris.subversion.subclipse.core.resources.LocalResourceStatus;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class SVNWorkspaceRoot {
    private ISVNLocalFolder localRoot;
    private String url;
    private static boolean nullResourceLogged = false;
    private static Set sharedProjects = new HashSet();

    public SVNWorkspaceRoot(IContainer resource) {
        this.localRoot = SVNWorkspaceRoot.getSVNFolderFor(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isManagedBySubclipse(IProject project) {
        if (project == null) {
            return false;
        }
        Set set = sharedProjects;
        synchronized (set) {
            block5: {
                if (!sharedProjects.contains(project)) break block5;
                return true;
            }
        }
        return RepositoryProvider.getProvider((IProject)project, (String)SVNProviderPlugin.getTypeId()) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setManagedBySubclipse(IProject project) {
        Set set = sharedProjects;
        synchronized (set) {
            sharedProjects.add(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unsetManagedBySubclipse(IProject project) {
        Set set = sharedProjects;
        synchronized (set) {
            sharedProjects.remove(project);
        }
    }

    public static String getProjectName(ISVNRemoteFolder folder, IProgressMonitor monitor) throws Exception {
        String string;
        ISVNClientAdapter client = folder.getRepository().getSVNClient();
        try {
            client.getNotificationHandler().disableLog();
            String result = folder.getName();
            InputStream is = client.getContent(folder.getUrl().appendPath(".project"), SVNRevision.HEAD);
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = db.parse(is);
            is.close();
            NodeList nl = doc.getDocumentElement().getChildNodes();
            int j = 0;
            while (j < nl.getLength()) {
                Node grandChild;
                Node child = nl.item(j);
                if (child instanceof Element && "name".equals(child.getNodeName()) && (grandChild = child.getFirstChild()) instanceof Text) {
                    result = ((Text)grandChild).getData();
                }
                ++j;
            }
            string = result;
            Object var11_13 = null;
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                client.getNotificationHandler().enableLog();
                throw throwable;
            }
        }
        client.getNotificationHandler().enableLog();
        return string;
    }

    public static IProject getProject(ISVNRemoteFolder folder, IProgressMonitor monitor) throws Exception {
        String name = SVNWorkspaceRoot.getProjectName(folder, monitor);
        return SVNWorkspaceRoot.getProject(name);
    }

    public static IProject getProject(String name) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(name);
    }

    public static void checkout(ISVNRemoteFolder[] resources, IProject[] projects, IProgressMonitor monitor) throws SVNException {
        CheckoutCommand command = new CheckoutCommand(resources, projects);
        command.run(monitor);
    }

    public static void shareProject(ISVNRepositoryLocation location, IProject project, String remoteDirName, String comment, boolean createDirectory, IProgressMonitor monitor) throws TeamException {
        ShareProjectCommand command = new ShareProjectCommand(location, project, remoteDirName, createDirectory);
        command.setComment(comment);
        command.run(monitor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setSharing(IProject project, IProgressMonitor monitor) throws TeamException {
        LocalResourceStatus status = SVNWorkspaceRoot.peekResourceStatusFor((IResource)project);
        if (!status.hasRemote()) {
            throw new SVNException((IStatus)new SVNStatus(4, Policy.bind("SVNProvider.infoMismatch", project.getName())));
        }
        String repositoryURL = null;
        ISVNClientAdapter client = SVNProviderPlugin.getPlugin().getSVNClient();
        try {
            try {
                SVNProviderPlugin.disableConsoleLogging();
                ISVNInfo info = client.getInfoFromWorkingCopy(project.getLocation().toFile());
                if (info.getRepository() != null) {
                    repositoryURL = info.getRepository().toString();
                }
            }
            catch (SVNClientException sVNClientException) {}
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            SVNProviderPlugin.enableConsoleLogging();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        SVNProviderPlugin.enableConsoleLogging();
        if (repositoryURL == null) {
            repositoryURL = status.getUrlString();
        }
        SVNProviderPlugin.getPlugin().getRepositories().getRepository(repositoryURL, false);
        RepositoryProvider.map((IProject)project, (String)SVNProviderPlugin.getTypeId());
    }

    public static ISVNLocalFolder getSVNFolderFor(IContainer resource) {
        return new LocalFolder(resource);
    }

    public static ISVNLocalFile getSVNFileFor(IFile resource) {
        return new LocalFile(resource);
    }

    public static ISVNLocalResource getSVNResourceFor(IResource resource) {
        if (resource.getType() == 1) {
            return SVNWorkspaceRoot.getSVNFileFor((IFile)resource);
        }
        return SVNWorkspaceRoot.getSVNFolderFor((IContainer)resource);
    }

    public static ISVNLocalResource[] getSVNResourcesFor(IResource[] resources) {
        ISVNLocalResource[] svnResources = new ISVNLocalResource[resources.length];
        int i = 0;
        while (i < resources.length) {
            svnResources[i] = SVNWorkspaceRoot.getSVNResourceFor(resources[i]);
            ++i;
        }
        return svnResources;
    }

    public static ISVNRemoteResource getBaseResourceFor(IResource resource) throws SVNException {
        ISVNLocalResource managed = SVNWorkspaceRoot.getSVNResourceFor(resource);
        return managed.getBaseResource();
    }

    public static ISVNRemoteResource getLatestResourceFor(IResource resource) throws SVNException {
        ISVNLocalResource managed = SVNWorkspaceRoot.getSVNResourceFor(resource);
        return managed.getLatestRemoteResource();
    }

    public static LocalResourceStatus peekResourceStatusFor(IResource resource) throws SVNException {
        PeekStatusCommand command = new PeekStatusCommand(resource);
        command.execute(SVNProviderPlugin.getPlugin().getSVNClient());
        return command.getLocalResourceStatus();
    }

    public static LocalResourceStatus peekResourceStatusFor(IPath path) throws SVNException {
        PeekStatusCommand command = new PeekStatusCommand(path);
        command.execute(SVNProviderPlugin.getPlugin().getSVNClient());
        return command.getLocalResourceStatus();
    }

    public ISVNRepositoryLocation getRepository() throws SVNException {
        if (this.url == null) {
            LocalResourceStatus status = this.localRoot.getStatus();
            if (!status.isManaged()) {
                throw new SVNException(Policy.bind("SVNWorkspaceRoot.notSVNFolder", this.localRoot.getName()));
            }
            this.url = status.getUrlString();
        }
        return SVNProviderPlugin.getPlugin().getRepository(this.url);
    }

    public ISVNLocalFolder getLocalRoot() {
        return this.localRoot;
    }

    public static boolean isLinkedResource(IResource resource) {
        return resource.isLinked(512);
    }

    public static boolean isSvnMetaResource(IResource resource) {
        if (resource.getType() == 2 && SVNProviderPlugin.getPlugin().isAdminDirectory(resource.getName())) {
            return true;
        }
        IContainer parent = resource.getParent();
        if (parent == null) {
            return false;
        }
        return SVNWorkspaceRoot.isSvnMetaResource((IResource)parent);
    }

    public static int getResourceType(IPath aResourcePath) {
        if (aResourcePath == null) {
            return 0;
        }
        IResource r = ResourcesPlugin.getWorkspace().getRoot().findMember(aResourcePath);
        return r == null ? 0 : r.getType();
    }

    public static IResource getResourceFor(IResource parent, IPath location) {
        if (parent == null || location == null) {
            return null;
        }
        if (parent instanceof IWorkspaceRoot) {
            return null;
        }
        if (!SVNWorkspaceRoot.isManagedBySubclipse(parent.getProject())) {
            return null;
        }
        if (!parent.getLocation().isPrefixOf(location)) {
            return null;
        }
        int segmentsToRemove = parent.getLocation().segmentCount();
        IPath fullPath = parent.getFullPath().append(location.removeFirstSegments(segmentsToRemove));
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember(fullPath);
        if (resource != null) {
            return resource;
        }
        if (parent instanceof IFile) {
            return null;
        }
        if (fullPath.isRoot()) {
            return root;
        }
        if (fullPath.segmentCount() == 1) {
            return root.getProject(fullPath.segment(0));
        }
        if (!location.toFile().exists() && location.toFile().getName().indexOf(".") == -1) {
            return root.getFolder(fullPath);
        }
        if (location.toFile().isDirectory()) {
            return root.getFolder(fullPath);
        }
        return root.getFile(fullPath);
    }

    public static IResource getResourceFor(IResource parent, ISVNStatus status) {
        if (status == null || status.getFile() == null) {
            return null;
        }
        return SVNWorkspaceRoot.getResourceFor(parent, (IPath)new Path(status.getFile().getAbsolutePath()));
    }

    public static IResource[] getResourcesFor(IPath location) {
        return SVNWorkspaceRoot.getResourcesFor(location, true);
    }

    public static IResource[] getResourcesFor(IPath location, boolean includeProjects) {
        LinkedHashSet<Object> resources = new LinkedHashSet<Object>();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = root.getProjects();
        int i = 0;
        while (i < projects.length) {
            IResource resource = SVNWorkspaceRoot.getResourceFor((IResource)projects[i], location);
            if (resource != null) {
                resources.add(resource);
            }
            if (includeProjects && SVNWorkspaceRoot.isManagedBySubclipse(projects[i]) && location.isPrefixOf(projects[i].getLocation())) {
                resources.add(projects[i]);
            }
            ++i;
        }
        return resources.toArray(new IResource[resources.size()]);
    }

    public static ISVNRepositoryLocation getRepositoryFor(IPath location) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = root.getProjects();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            if (project.getLocation().isPrefixOf(location) && SVNWorkspaceRoot.isManagedBySubclipse(project)) {
                try {
                    SVNTeamProvider teamProvider = (SVNTeamProvider)RepositoryProvider.getProvider((IProject)project, (String)SVNProviderPlugin.getTypeId());
                    return teamProvider.getSVNWorkspaceRoot().getRepository();
                }
                catch (SVNException e) {
                    SVNProviderPlugin.log(e);
                    return null;
                }
            }
            ++i;
        }
        return null;
    }
}

