/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.discourse.ui.relation;

import edu.mit.discourse.core.rep.relation.IArgument;
import edu.mit.discourse.core.rep.relation.ILexicalMarker;
import edu.mit.discourse.ui.relation.AdjunctProxy;
import edu.mit.discourse.ui.relation.ArgumentProxy;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.model.IStoryData;

public class LexicalMarkerProxy
extends ArgumentProxy
implements ILexicalMarker {
    ILexicalMarker.Type type = ILexicalMarker.Type.EXPLICIT;
    String implicitMarker = null;

    public LexicalMarkerProxy(String name) {
        super(name);
    }

    public void load(AdjunctProxy proxy, IStoryData data) {
        super.load(proxy, data);
        if (proxy instanceof LexicalMarkerProxy) {
            LexicalMarkerProxy lmProxy = (LexicalMarkerProxy)proxy;
            this.internalSetType(lmProxy.getType());
            this.internalSetImplicitMarker(lmProxy.getImplicitMarker());
        }
    }

    public void setType(ILexicalMarker.Type newType) {
        if (this.internalSetType(newType)) {
            this.notifyChangeListeners(this);
        }
    }

    protected boolean internalSetType(ILexicalMarker.Type newType) {
        if (this.type == newType) {
            return false;
        }
        this.type = newType;
        if (this.type == ILexicalMarker.Type.NULL) {
            this.displayText = "(null)";
            this.implicitMarker = null;
            this.tokenSegments.clear();
            this.setMakeReferent(false);
        } else if (this.type == ILexicalMarker.Type.IMPLICIT) {
            this.displayText = "? (implicit)";
            this.implicitMarker = "";
            this.tokenSegments.clear();
            this.setMakeReferent(false);
        } else if (this.type == ILexicalMarker.Type.EXPLICIT) {
            this.displayText = "?";
            this.implicitMarker = null;
        }
        return true;
    }

    public ILexicalMarker.Type getType() {
        return this.type;
    }

    public String getImplicitMarker() {
        return this.implicitMarker;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public void setImplicitMarker(String newMarker) {
        if (this.internalSetImplicitMarker(newMarker)) {
            this.notifyChangeListeners(this);
        }
    }

    protected boolean internalSetImplicitMarker(String newMarker) {
        if (this.type != ILexicalMarker.Type.IMPLICIT) {
            return false;
        }
        if (this.implicitMarker.equals(newMarker)) {
            return false;
        }
        this.implicitMarker = newMarker;
        this.displayText = String.valueOf(this.implicitMarker.length() == 0 ? "?" : this.implicitMarker) + " (implicit)";
        return true;
    }

    public boolean validate() {
        if (this.type == ILexicalMarker.Type.NULL) {
            return true;
        }
        if (this.type == ILexicalMarker.Type.IMPLICIT) {
            return this.displayText != "?";
        }
        return !this.tokenSegments.isEmpty();
    }

    public String getMessage() {
        if (this.type == ILexicalMarker.Type.NULL) {
            return null;
        }
        if (this.type == ILexicalMarker.Type.IMPLICIT) {
            return this.displayText == "?" ? "Text of implicit lexical marker not set" : null;
        }
        return this.tokenSegments.isEmpty() ? null : "Segments for explicit lexical marker not set";
    }

    public int getMessageType() {
        return this.validate() ? 0 : 3;
    }

    protected void internalClear() {
        super.internalClear();
        this.type = ILexicalMarker.Type.EXPLICIT;
        this.implicitMarker = "";
    }

    public boolean isExplicit() {
        return this.type == ILexicalMarker.Type.EXPLICIT;
    }

    public boolean isImplicit() {
        return this.type == ILexicalMarker.Type.IMPLICIT;
    }

    public boolean isNull() {
        return this.type == ILexicalMarker.Type.NULL;
    }

    public IDesc getSegment() {
        throw new UnsupportedOperationException();
    }

    public ILexicalMarker clone() {
        throw new UnsupportedOperationException();
    }

    public static LexicalMarkerProxy convert(ILexicalMarker lm, IStoryData data) {
        ArgumentProxy argProxy = ArgumentProxy.convert((IArgument)lm, data);
        LexicalMarkerProxy proxy = new LexicalMarkerProxy("Lexical Marker");
        proxy.load(argProxy, data);
        proxy.setType(lm.getType());
        if (lm.isImplicit()) {
            proxy.setImplicitMarker(lm.getImplicitMarker());
        }
        return proxy;
    }
}

