/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.discourse.ui.helpers;

import edu.mit.discourse.core.rep.referent.IReference;
import edu.mit.discourse.core.rep.referent.IReferent;
import edu.mit.discourse.core.rep.referent.RefPair;
import edu.mit.discourse.core.rep.referent.Referent;
import edu.mit.discourse.core.rep.referent.ReferentRep;
import edu.mit.discourse.core.rep.referent.change.MoveReferenceChange;
import edu.mit.discourse.core.rep.referent.change.RemoveReferenceChange;
import edu.mit.discourse.core.rep.referent.model.IReferenceModel;
import edu.mit.discourse.core.rep.refprops.RefPropRep;
import edu.mit.discourse.ui.DiscourseUIMessages;
import edu.mit.discourse.ui.DiscourseUIPlugin;
import edu.mit.discourse.ui.actions.RenameReferent;
import edu.mit.discourse.ui.actions.delegates.AddReferencesByPattern;
import edu.mit.discourse.ui.content.ReferentContentProvider;
import edu.mit.discourse.ui.dialogs.ReferentSelectionDialog;
import edu.mit.discourse.ui.helpers.ReferentCreatorPage;
import edu.mit.discourse.ui.label.ReferentLabelProvider;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.meta.timing.ITiming;
import edu.mit.story.core.meta.timing.Timing;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.IStoryData;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.model.change.IModelListener;
import edu.mit.story.core.model.change.RemoveDescriptionsChange;
import edu.mit.story.core.model.change.StoryChangeEvent;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.ui.WorkbenchUtils;
import edu.mit.story.ui.actions.ActionUtils;
import edu.mit.story.ui.actions.DescActionUtils;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.actions.generic.CollapseAllAction;
import edu.mit.story.ui.actions.generic.DeleteAction;
import edu.mit.story.ui.actions.generic.EditAction;
import edu.mit.story.ui.actions.generic.ExpandAllAction;
import edu.mit.story.ui.actions.generic.ResourceAction2;
import edu.mit.story.ui.actions.groups.StoryEditorUndoRedoActionGroup;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.helpers.HelperPage;
import edu.mit.story.ui.helpers.ICreatorPage;
import edu.mit.story.ui.helpers.IDetailsPage;
import edu.mit.story.ui.viewers.StoryElementComparer;
import edu.mit.story.ui.views.CreatorView;
import edu.mit.story.ui.widgets.HelperPageBookWidget;
import java.util.Date;
import java.util.HashMap;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;

public class ReferentDetailsPage
extends HelperPage
implements IDetailsPage,
IAdaptable,
IModelListener {
    public static final String ID = ReferentDetailsPage.class.getName();
    protected TreeViewer treeViewer;
    EditElementAction editAction;
    IAction deleteAction;
    IAction renameAction;
    IAction patternAddAction;
    IAction collapseAction;
    IAction expandAction;
    IAction sortByReferenceAction;
    IAction moveAction;
    ActionGroup undoRedoActions;

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public void createControl(Composite parent) {
        ReferentContentProvider cp = new ReferentContentProvider(this.getStoryEditor());
        ReferentLabelProvider lp = new ReferentLabelProvider(this.getStoryEditor());
        this.treeViewer = new TreeViewer(parent, 770);
        this.treeViewer.setComparer((IElementComparer)StoryElementComparer.getInstance());
        this.treeViewer.setAutoExpandLevel(2);
        this.treeViewer.setContentProvider((IContentProvider)cp);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)lp);
        this.treeViewer.setInput((Object)this.getStoryEditor());
        this.setControl((Control)this.treeViewer.getTree());
        this.editAction = new EditElementAction();
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this.editAction);
        this.deleteAction = new DeleteElementAction();
        this.renameAction = new RenameReferent(this.getStoryEditor(), (ISelectionProvider)this.treeViewer);
        this.patternAddAction = new AddByPatternAction();
        this.undoRedoActions = new StoryEditorUndoRedoActionGroup(this.getStoryEditor());
        this.collapseAction = new CollapseAllAction((AbstractTreeViewer)this.treeViewer, 2);
        this.expandAction = new ExpandAllAction((AbstractTreeViewer)this.treeViewer);
        this.sortByReferenceAction = new SortAction(this.treeViewer, cp);
        this.moveAction = new MoveReferenceAction();
        MenuManager manager = new MenuManager();
        ActionUtils.createPopupGroups((IMenuManager)manager);
        this.undoRedoActions.fillContextMenu((IMenuManager)manager);
        manager.appendToGroup("group.edit", this.renameAction);
        manager.appendToGroup("group.edit", (IAction)this.editAction);
        manager.appendToGroup("group.edit", this.deleteAction);
        manager.appendToGroup("group.edit", this.patternAddAction);
        manager.appendToGroup("group.edit", this.moveAction);
        Menu menu = manager.createContextMenu(this.getControl());
        this.treeViewer.getTree().setMenu(menu);
        this.getSite().registerContextMenu(String.valueOf(ID) + ".popupMenu", manager, (ISelectionProvider)this.treeViewer);
    }

    public void setActionBars(IActionBars actionBars) {
        actionBars.getToolBarManager().insertBefore("linking", this.collapseAction);
        actionBars.getToolBarManager().insertBefore(this.collapseAction.getId(), this.expandAction);
        actionBars.getToolBarManager().insertBefore(this.expandAction.getId(), this.sortByReferenceAction);
        actionBars.setGlobalActionHandler(this.collapseAction.getActionDefinitionId(), this.collapseAction);
        actionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), this.renameAction);
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), this.deleteAction);
        this.undoRedoActions.fillActionBars(actionBars);
        actionBars.updateActionBars();
    }

    public void setStoryEditor(IStoryEditor newEditor) {
        super.setStoryEditor(newEditor);
        this.getStoryEditor().getStoryModel().addModelListener((IModelListener)this);
    }

    public void modelChanged(StoryChangeEvent e) {
        if (this.treeViewer == null) {
            return;
        }
        if (e.affects(ReferentRep.getInstance()) || e.affects(RefPropRep.getInstance())) {
            this.treeViewer.refresh();
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ISelectionProvider.class) {
            return this.treeViewer;
        }
        if (adapter == IPostSelectionProvider.class) {
            return this.treeViewer;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public void dispose() {
        this.getStoryEditor().getStoryModel().removeModelListener((IModelListener)this);
        super.dispose();
    }

    protected class AddByPatternAction
    extends ResourceAction2
    implements ISelectionChangedListener {
        public AddByPatternAction() {
            super(DiscourseUIMessages.getBundle(), DiscourseUIMessages.ACTION_AddReferencesByPattern_prefix);
            ReferentDetailsPage.this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        }

        public void run() {
            IDesc desc = (IDesc)SelectionUtils.extractSingle((ISelection)ReferentDetailsPage.this.treeViewer.getSelection(), IDesc.class);
            if (desc != null && !AddReferencesByPattern.addByPattern(ReferentDetailsPage.this.getStoryEditor(), desc, (Object)this)) {
                PlatformUI.getWorkbench().getDisplay().beep();
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IDesc desc = (IDesc)SelectionUtils.extractSingle((ISelection)ReferentDetailsPage.this.treeViewer.getSelection(), IDesc.class);
            this.setEnabled(ReferentRep.getInstance().isType((IHasRep)desc));
        }
    }

    protected class DeleteElementAction
    extends DeleteAction
    implements ISelectionChangedListener {
        public DeleteElementAction() {
            ReferentDetailsPage.this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        }

        protected void doDelete() {
            Timing timing = new Timing("user", true);
            ISelection sel = ReferentDetailsPage.this.treeViewer.getSelection();
            RefPair dumRef = (RefPair)SelectionUtils.extractSingle((ISelection)sel, RefPair.class);
            if (dumRef != null) {
                ReferentDetailsPage.this.getStoryEditor().getStoryModel().applyChange((Object)this, (IModelChange)new RemoveReferenceChange(dumRef.ref, dumRef.desc, (ITiming)timing), false);
                return;
            }
            IDesc desc = (IDesc)SelectionUtils.extractSingle((ISelection)sel, IDesc.class);
            if (desc != null) {
                ReferentDetailsPage.this.getStoryEditor().getStoryModel().applyChange((Object)this, (IModelChange)new RemoveDescriptionsChange(desc), false);
                return;
            }
            IReference reference = (IReference)SelectionUtils.extractSingle((ISelection)sel, IReference.class);
            desc = Referent.findParent((IReference)reference, (IStoryData)ReferentDetailsPage.this.getStoryEditor().getStoryModel().getData());
            if (desc == null) {
                throw new IllegalStateException();
            }
            ReferentDetailsPage.this.getStoryEditor().getStoryModel().applyChange((Object)this, (IModelChange)new RemoveReferenceChange(reference, desc, (ITiming)timing), false);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection sel = ReferentDetailsPage.this.treeViewer.getSelection();
            IDesc desc = (IDesc)SelectionUtils.extractSingle((ISelection)sel, IDesc.class);
            if (desc != null) {
                this.setEnabled(DescActionUtils.canDelete((IDesc)desc, (IMutableStoryModel)ReferentDetailsPage.this.getStoryEditor().getStoryModel()));
                return;
            }
            IReference ref = (IReference)SelectionUtils.extractSingle((ISelection)sel, IReference.class);
            if (ref != null) {
                this.setEnabled(true);
                return;
            }
            RefPair dumRef = (RefPair)SelectionUtils.extractSingle((ISelection)sel, RefPair.class);
            if (dumRef != null) {
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }
    }

    protected class EditElementAction
    extends EditAction
    implements ISelectionChangedListener {
        protected EditElementAction() {
        }

        protected void doEdit() {
            IWorkbenchWindow window;
            IViewPart part;
            CreatorView view;
            ISelection sel = ReferentDetailsPage.this.treeViewer.getSelection();
            IDesc desc = (IDesc)SelectionUtils.extractSingle((ISelection)sel, IDesc.class);
            IDesc refDesc = null;
            IReference ref = null;
            RefPair dummy = null;
            if (desc == null) {
                ref = (IReference)SelectionUtils.extractSingle((ISelection)sel, IReference.class);
                if (ref != null) {
                    IReferent referent = ref.getParent();
                    for (IDesc d : ReferentDetailsPage.this.getStoryEditor().getStoryModel().getData().getDescriptions(ReferentRep.getInstance())) {
                        if (d.getData() != referent) continue;
                        refDesc = d;
                        break;
                    }
                }
                if ((dummy = (RefPair)SelectionUtils.extractSingle((ISelection)sel, RefPair.class)) != null) {
                    ref = dummy.ref;
                    refDesc = dummy.desc;
                }
            } else if (ReferentRep.getInstance().isType((IHasRep)desc)) {
                refDesc = desc;
            }
            if ((view = (CreatorView)SelectionUtils.cast((Object)(part = WorkbenchUtils.openView((IWorkbenchWindow)(window = ReferentDetailsPage.this.getStoryEditor().getEditorSite().getWorkbenchWindow()), (String)"edu.mit.story.ui.views.CreatorView")), CreatorView.class)) == null) {
                return;
            }
            Control control = view.getCurrentPage().getControl();
            CreatorView.CreatorPageBookWidget widget = (CreatorView.CreatorPageBookWidget)SelectionUtils.cast((Object)control, CreatorView.CreatorPageBookWidget.class);
            if (widget == null) {
                return;
            }
            HelperPageBookWidget.HelperPageDesc cPage = widget.showPage("edu.mit.discourse.ui.helpers.ReferentCreatorPage");
            if (cPage == null) {
                return;
            }
            ICreatorPage creator = (ICreatorPage)cPage.getHelper();
            ReferentCreatorPage page = (ReferentCreatorPage)SelectionUtils.cast((Object)creator, ReferentCreatorPage.class);
            if (page == null) {
                return;
            }
            page.getController().load(refDesc);
            if (ref != null) {
                IReferenceModel refModel = page.getController().getReferentModel().getReference(ref.getID());
                page.getController().getReferenceController().load((IReference)refModel);
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection sel = ReferentDetailsPage.this.treeViewer.getSelection();
            IDesc desc = (IDesc)SelectionUtils.extractSingle((ISelection)sel, IDesc.class);
            if (ReferentRep.getInstance().isType((IHasRep)desc) || RefPropRep.getInstance().isType((IHasRep)desc)) {
                this.setEnabled(true);
                return;
            }
            IReference ref = (IReference)SelectionUtils.extractSingle((ISelection)sel, IReference.class);
            if (ref != null) {
                this.setEnabled(true);
                return;
            }
            RefPair dumRef = (RefPair)SelectionUtils.extractSingle((ISelection)sel, RefPair.class);
            if (dumRef != null) {
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }
    }

    protected class MoveReferenceAction
    extends ResourceAction2
    implements ISelectionChangedListener {
        public MoveReferenceAction() {
            super(DiscourseUIMessages.getBundle(), DiscourseUIMessages.ACTION_MoveReference_prefix);
            ReferentDetailsPage.this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        }

        public void run() {
            Date start = new Date();
            IDesc target = ReferentSelectionDialog.open(ReferentDetailsPage.this.getStoryEditor(), "Select Target", "Select the referent to which the references should be moved");
            if (target == null) {
                return;
            }
            IStructuredSelection ssel = SelectionUtils.castAsStructuredSelection((ISelection)ReferentDetailsPage.this.treeViewer.getSelection());
            HashMap<IReference, IDesc> refs = new HashMap<IReference, IDesc>(ssel.size());
            Object[] objectArray = ssel.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDesc d;
                Object o = objectArray[n2];
                if (o instanceof IReference) {
                    IReference refexp = (IReference)o;
                    d = Referent.findParent((IReference)refexp, (IStoryData)ReferentDetailsPage.this.getStoryEditor().getStoryModel().getData());
                    refs.put(refexp, d);
                } else if (o instanceof RefPair) {
                    RefPair p = (RefPair)o;
                    refs.put(p.ref, p.desc);
                } else if (o instanceof IDesc) {
                    d = (IDesc)o;
                    IReferent coref = (IReferent)d.getData();
                    for (IReference r : coref.getReferences()) {
                        refs.put(r, d);
                    }
                }
                ++n2;
            }
            if (refs.isEmpty()) {
                Display.getDefault().beep();
                return;
            }
            Timing timing = new Timing(start, ((Object)((Object)this)).getClass().getCanonicalName());
            ReferentDetailsPage.this.getStoryEditor().getStoryModel().applyChange((Object)this, (IModelChange)new MoveReferenceChange(refs, target, (ITiming)timing), false);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            boolean enable;
            block3: {
                IStructuredSelection ssel = SelectionUtils.castAsStructuredSelection((ISelection)event.getSelection());
                enable = false;
                if (ssel == null) break block3;
                enable = ssel.size() > 0;
                Object[] objectArray = ssel.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    block4: {
                        block5: {
                            Object o = objectArray[n2];
                            if (o instanceof IReference || o instanceof RefPair) break block4;
                            if (!(o instanceof IDesc)) break block5;
                            IDesc d = (IDesc)o;
                            if (ReferentRep.getInstance().isType((IHasRep)d)) break block4;
                        }
                        enable = false;
                        break;
                    }
                    ++n2;
                }
            }
            this.setEnabled(enable);
        }
    }

    protected class SortAction
    extends Action {
        private final TreeViewer viewer;
        private final ReferentContentProvider cp;

        public SortAction(TreeViewer viewer, ReferentContentProvider cp) {
            super(null, 2);
            if (viewer == null) {
                throw new NullPointerException();
            }
            if (cp == null) {
                throw new NullPointerException();
            }
            this.viewer = viewer;
            this.cp = cp;
            this.setId("sortByReference");
            this.setToolTipText("Sort by Reference");
            this.setChecked(cp.isSortingByReference());
            this.setImageDescriptor(DiscourseUIPlugin.getDefault().getImageRegistry().getDescriptor("elcl16/sort_by_reference.gif"));
        }

        public void run() {
            this.cp.setSortByReference(this.isChecked());
            this.viewer.refresh();
        }
    }
}

