/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.reconciler.dropins;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.artifact.repository.ArtifactRepositoryManager;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.core.helpers.URLUtil;
import org.eclipse.equinox.internal.p2.extensionlocation.ExtensionLocationArtifactRepositoryFactory;
import org.eclipse.equinox.internal.p2.extensionlocation.ExtensionLocationMetadataRepositoryFactory;
import org.eclipse.equinox.internal.p2.metadata.repository.MetadataRepositoryManager;
import org.eclipse.equinox.internal.p2.reconciler.dropins.DropinsRepositoryListener;
import org.eclipse.equinox.internal.p2.reconciler.dropins.PlatformXmlListener;
import org.eclipse.equinox.internal.p2.reconciler.dropins.ProfileSynchronizer;
import org.eclipse.equinox.internal.p2.update.Configuration;
import org.eclipse.equinox.internal.p2.update.Utils;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.directorywatcher.DirectoryChangeListener;
import org.eclipse.equinox.internal.provisional.p2.directorywatcher.DirectoryWatcher;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class Activator
implements BundleActivator {
    public static final String ID = "org.eclipse.equinox.p2.reconciler.dropins";
    private static final String DROPINS_DIRECTORY = "org.eclipse.equinox.p2.reconciler.dropins.directory";
    private static final String DROPINS = "dropins";
    private static final String LINKS = "links";
    private static final String CONFIG_INI = "config.ini";
    private static final String PLATFORM_CFG = "org.eclipse.update/platform.xml";
    private static final String CACHE_FILENAME = "cache.timestamps";
    private static PackageAdmin packageAdmin;
    private static BundleContext bundleContext;
    private ServiceReference packageAdminRef;
    private List watchers = new ArrayList();
    private static final Set repositories;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    static {
        repositories = new HashSet();
    }

    public static IMetadataRepository createExtensionLocationMetadataRepository(URL location, String name, Map properties) throws ProvisionException {
        IMetadataRepositoryManager manager;
        BundleContext context = Activator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)context, (String)clazz.getName())) == null) {
            throw new IllegalStateException("MetadataRepositoryManager not registered.");
        }
        ExtensionLocationMetadataRepositoryFactory factory = new ExtensionLocationMetadataRepositoryFactory();
        IMetadataRepository repository = factory.create(location, name, "org.eclipse.equinox.p2.extensionlocation.metadataRepository", properties);
        ((MetadataRepositoryManager)manager).addRepository(repository);
        return repository;
    }

    public static IMetadataRepository loadMetadataRepository(URL location, IProgressMonitor monitor) throws ProvisionException {
        IMetadataRepositoryManager manager;
        BundleContext context = Activator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)context, (String)clazz.getName())) == null) {
            throw new IllegalStateException("MetadataRepositoryManager not registered.");
        }
        return manager.loadRepository(location, monitor);
    }

    public static IArtifactRepository createExtensionLocationArtifactRepository(URL location, String name, Map properties) throws ProvisionException {
        IArtifactRepositoryManager manager;
        BundleContext context = Activator.getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IArtifactRepositoryManager)ServiceHelper.getService((BundleContext)context, (String)clazz.getName())) == null) {
            throw new IllegalStateException("ArtifactRepositoryManager not registered.");
        }
        ExtensionLocationArtifactRepositoryFactory factory = new ExtensionLocationArtifactRepositoryFactory();
        IArtifactRepository repository = factory.create(location, name, "org.eclipse.equinox.p2.extensionlocation.artifactRepository", properties);
        ((ArtifactRepositoryManager)manager).addRepository(repository);
        return repository;
    }

    public static IArtifactRepository loadArtifactRepository(URL location, IProgressMonitor monitor) throws ProvisionException {
        IArtifactRepositoryManager manager;
        BundleContext context = Activator.getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IArtifactRepositoryManager)ServiceHelper.getService((BundleContext)context, (String)clazz.getName())) == null) {
            throw new IllegalStateException("ArtifactRepositoryManager not registered.");
        }
        return manager.loadRepository(location, monitor);
    }

    public static Set getRepositories() {
        return repositories;
    }

    public void start(BundleContext context) throws Exception {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.osgi.service.packageadmin.PackageAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.packageAdminRef = context.getServiceReference(clazz.getName());
        Activator.setPackageAdmin((PackageAdmin)context.getService(this.packageAdminRef));
        bundleContext = context;
        if (this.isUpToDate()) {
            return;
        }
        if (!this.startEarly("org.eclipse.equinox.p2.exemplarysetup")) {
            return;
        }
        if (!this.startEarly("org.eclipse.equinox.simpleconfigurator.manipulator")) {
            return;
        }
        if (!this.startEarly("org.eclipse.equinox.frameworkadmin.equinox")) {
            return;
        }
        IProfile profile = Activator.getCurrentProfile(context);
        if (profile == null) {
            return;
        }
        this.checkConfigIni();
        this.removeOldRepos();
        this.watchDropins(profile);
        this.watchConfiguration();
        Activator.synchronize(null);
        this.writeTimestamps();
        repositories.clear();
    }

    private void checkConfigIni() {
        File configuration = Activator.getConfigurationLocation();
        if (configuration == null) {
            LogHelper.log((IStatus)new Status(4, ID, "Unable to determine configuration location."));
            return;
        }
        File configIni = new File(configuration, CONFIG_INI);
        if (!configIni.exists()) {
            File parentConfiguration = Activator.getParentConfigurationLocation();
            if (parentConfiguration == null) {
                return;
            }
            Properties props = new Properties();
            try {
                OutputStream os = null;
                try {
                    os = new BufferedOutputStream(new FileOutputStream(configIni));
                    String externalForm = Utils.makeRelative((String)parentConfiguration.toURL().toExternalForm(), (URL)Activator.getOSGiInstallArea()).replace('\\', '/');
                    props.put("osgi.sharedConfiguration.area", externalForm);
                    props.store(os, "Linked configuration");
                }
                finally {
                    if (os != null) {
                        os.close();
                    }
                }
            }
            catch (IOException e) {
                LogHelper.log((IStatus)new Status(4, ID, "Unable to create linked configuration location.", (Throwable)e));
            }
        }
    }

    private boolean isUpToDate() {
        File parentConfiguration;
        if ("true".equals(Activator.getContext().getProperty("osgi.checkConfiguration"))) {
            return false;
        }
        Properties timestamps = this.readTimestamps();
        if (timestamps.isEmpty()) {
            return false;
        }
        File configuration = Activator.getConfigurationLocation();
        if (configuration != null) {
            File platformXML = new File(configuration, PLATFORM_CFG);
            if (!Long.toString(platformXML.lastModified()).equals(timestamps.getProperty(platformXML.getAbsolutePath()))) {
                return false;
            }
            File parent = configuration.getParentFile();
            if (parent != null) {
                File plugins = new File(parent, "plugins");
                if (!Long.toString(plugins.lastModified()).equals(timestamps.getProperty(plugins.getAbsolutePath()))) {
                    return false;
                }
                File features = new File(parent, "features");
                if (!Long.toString(features.lastModified()).equals(timestamps.getProperty(features.getAbsolutePath()))) {
                    return false;
                }
            }
        }
        if ((parentConfiguration = Activator.getParentConfigurationLocation()) != null) {
            File platformXML = new File(parentConfiguration, PLATFORM_CFG);
            if (!Long.toString(platformXML.lastModified()).equals(timestamps.getProperty(platformXML.getAbsolutePath()))) {
                return false;
            }
            File parent = parentConfiguration.getParentFile();
            if (parent != null) {
                File plugins = new File(parent, "plugins");
                if (!Long.toString(plugins.lastModified()).equals(timestamps.getProperty(plugins.getAbsolutePath()))) {
                    return false;
                }
                File features = new File(parent, "features");
                if (!Long.toString(features.lastModified()).equals(timestamps.getProperty(features.getAbsolutePath()))) {
                    return false;
                }
            }
        }
        File[] dropins = Activator.getDropinsDirectories();
        int i = 0;
        while (i < dropins.length) {
            if (!Long.toString(dropins[i].lastModified()).equals(timestamps.getProperty(dropins[i].getAbsolutePath()))) {
                return false;
            }
            ++i;
        }
        File[] links = Activator.getLinksDirectories();
        int i2 = 0;
        while (i2 < links.length) {
            if (!Long.toString(links[i2].lastModified()).equals(timestamps.getProperty(links[i2].getAbsolutePath()))) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    private Properties readTimestamps() {
        Properties result;
        block15: {
            result = new Properties();
            File file = Activator.getContext().getDataFile(CACHE_FILENAME);
            if (!file.exists()) {
                return result;
            }
            InputStream input = null;
            try {
                try {
                    input = new BufferedInputStream(new FileInputStream(file));
                    result.load(input);
                }
                catch (IOException e) {
                    LogHelper.log((IStatus)new Status(4, ID, "Error occurred while reading cached timestamps for reconciliation.", (Throwable)e));
                    try {
                        if (input != null) {
                            input.close();
                        }
                        break block15;
                    }
                    catch (IOException iOException) {}
                    break block15;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    private void writeTimestamps() {
        block20: {
            File parentConfiguration;
            Properties timestamps = new Properties();
            File configuration = Activator.getConfigurationLocation();
            if (configuration != null) {
                File platformXML = new File(configuration, PLATFORM_CFG);
                timestamps.put(platformXML.getAbsolutePath(), Long.toString(platformXML.lastModified()));
                File parent = configuration.getParentFile();
                if (parent != null) {
                    File plugins = new File(parent, "plugins");
                    timestamps.put(plugins.getAbsolutePath(), Long.toString(plugins.lastModified()));
                    File features = new File(parent, "features");
                    timestamps.put(features.getAbsolutePath(), Long.toString(features.lastModified()));
                }
            }
            if ((parentConfiguration = Activator.getParentConfigurationLocation()) != null) {
                File platformXML = new File(parentConfiguration, PLATFORM_CFG);
                timestamps.put(platformXML.getAbsolutePath(), Long.toString(platformXML.lastModified()));
                File parent = parentConfiguration.getParentFile();
                if (parent != null) {
                    File plugins = new File(parent, "plugins");
                    timestamps.put(plugins.getAbsolutePath(), Long.toString(plugins.lastModified()));
                    File features = new File(parent, "features");
                    timestamps.put(features.getAbsolutePath(), Long.toString(features.lastModified()));
                }
            }
            File[] dropins = Activator.getDropinsDirectories();
            int i = 0;
            while (i < dropins.length) {
                timestamps.put(dropins[i].getAbsolutePath(), Long.toString(dropins[i].lastModified()));
                ++i;
            }
            File[] links = Activator.getLinksDirectories();
            int i2 = 0;
            while (i2 < links.length) {
                timestamps.put(links[i2].getAbsolutePath(), Long.toString(links[i2].lastModified()));
                ++i2;
            }
            File file = Activator.getContext().getDataFile(CACHE_FILENAME);
            OutputStream output = null;
            try {
                try {
                    file.delete();
                    output = new BufferedOutputStream(new FileOutputStream(file));
                    timestamps.store(output, null);
                }
                catch (IOException e) {
                    LogHelper.log((IStatus)new Status(4, ID, "Error occurred while writing cache timestamps for reconciliation.", (Throwable)e));
                    if (output != null) {
                        try {
                            output.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block20;
                }
            }
            catch (Throwable throwable) {
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void removeOldRepos() {
        IMetadataRepositoryManager metadataManager;
        IArtifactRepositoryManager artifactManager;
        URL osgiInstallArea = Activator.getOSGiInstallArea();
        if (osgiInstallArea == null) {
            return;
        }
        URL location = null;
        try {
            location = new URL(Activator.getOSGiInstallArea(), ".pooled");
        }
        catch (MalformedURLException e) {
            LogHelper.log((IStatus)new Status(4, ID, "Error occurred while removing old repositories.", (Throwable)e));
            return;
        }
        BundleContext context = Activator.getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((artifactManager = (IArtifactRepositoryManager)ServiceHelper.getService((BundleContext)context, (String)clazz.getName())) == null) {
            throw new IllegalStateException("ArtifactRepositoryManager not registered.");
        }
        artifactManager.removeRepository(location);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((metadataManager = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)context, (String)clazz2.getName())) == null) {
            throw new IllegalStateException("MetadataRepositoryManager not registered.");
        }
        metadataManager.removeRepository(location);
    }

    private boolean startEarly(String bundleName) throws BundleException {
        Bundle bundle = Activator.getBundle(bundleName);
        if (bundle == null) {
            return false;
        }
        bundle.start(1);
        return true;
    }

    public static synchronized void synchronize(IProgressMonitor monitor) {
        IProfile profile = Activator.getCurrentProfile(bundleContext);
        if (profile == null) {
            return;
        }
        ProfileSynchronizer synchronizer = new ProfileSynchronizer(profile, repositories);
        IStatus result = synchronizer.synchronize(monitor);
        if (!result.isOK() && result.getSeverity() != 8) {
            LogHelper.log((IStatus)result);
        }
    }

    private void watchConfiguration() {
        File configFile = Activator.getConfigurationLocation();
        if (configFile == null) {
            LogHelper.log((IStatus)new Status(4, ID, "Unable to determine configuration location."));
            return;
        }
        if (!(configFile = new File(configFile, PLATFORM_CFG)).exists()) {
            File parentConfiguration = Activator.getParentConfigurationLocation();
            if (parentConfiguration == null) {
                return;
            }
            File shareConfigFile = new File(parentConfiguration, PLATFORM_CFG);
            if (!shareConfigFile.exists()) {
                return;
            }
            Configuration config = new Configuration();
            config.setDate(Long.toString(new Date().getTime()));
            config.setVersion("3.0");
            try {
                String sharedUR = Utils.makeRelative((String)shareConfigFile.toURL().toExternalForm(), (URL)Activator.getOSGiInstallArea()).replace('\\', '/');
                config.setSharedUR(sharedUR);
                configFile.getParentFile().mkdirs();
                config.save(configFile, Activator.getOSGiInstallArea());
            }
            catch (IOException e) {
                LogHelper.log((IStatus)new Status(4, ID, "Unable to create linked platform.xml.", (Throwable)e));
                return;
            }
            catch (ProvisionException e) {
                LogHelper.log((IStatus)new Status(4, ID, "Unable to create linked platform.xml.", (Throwable)e));
                return;
            }
        }
        DirectoryWatcher watcher = new DirectoryWatcher(configFile.getParentFile());
        PlatformXmlListener listener = new PlatformXmlListener(configFile);
        watcher.addListener((DirectoryChangeListener)listener);
        watcher.poll();
        repositories.addAll(listener.getMetadataRepositories());
    }

    private void watchDropins(IProfile profile) {
        ArrayList<File> directories = new ArrayList<File>();
        File[] dropinsDirectories = Activator.getDropinsDirectories();
        directories.addAll(Arrays.asList(dropinsDirectories));
        File[] linksDirectories = Activator.getLinksDirectories();
        directories.addAll(Arrays.asList(linksDirectories));
        if (directories.isEmpty()) {
            return;
        }
        DropinsRepositoryListener listener = new DropinsRepositoryListener(Activator.getContext(), DROPINS);
        DirectoryWatcher watcher = new DirectoryWatcher(directories.toArray(new File[directories.size()]));
        watcher.addListener((DirectoryChangeListener)listener);
        watcher.poll();
        repositories.addAll(listener.getMetadataRepositories());
    }

    public void stop(BundleContext context) throws Exception {
        Iterator iter = this.watchers.iterator();
        while (iter.hasNext()) {
            DirectoryWatcher watcher = (DirectoryWatcher)iter.next();
            watcher.stop();
        }
        bundleContext = null;
        Activator.setPackageAdmin(null);
        context.ungetService(this.packageAdminRef);
    }

    public static BundleContext getContext() {
        return bundleContext;
    }

    public static File getConfigurationLocation() {
        Location configurationLocation;
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.osgi.service.datalocation.Location");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((configurationLocation = (Location)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName(), (String)Location.CONFIGURATION_FILTER)) == null || !configurationLocation.isSet()) {
            return null;
        }
        URL url = configurationLocation.getURL();
        if (url == null) {
            return null;
        }
        return URLUtil.toFile((URL)url);
    }

    public static File getParentConfigurationLocation() {
        Location configurationLocation;
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.osgi.service.datalocation.Location");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((configurationLocation = (Location)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName(), (String)Location.CONFIGURATION_FILTER)) == null || !configurationLocation.isSet()) {
            return null;
        }
        Location sharedConfigurationLocation = configurationLocation.getParentLocation();
        if (sharedConfigurationLocation == null) {
            return null;
        }
        URL url = sharedConfigurationLocation.getURL();
        if (url == null) {
            return null;
        }
        return URLUtil.toFile((URL)url);
    }

    public static URL getOSGiInstallArea() {
        Location location;
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.osgi.service.datalocation.Location");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((location = (Location)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName(), (String)Location.INSTALL_FILTER)) == null) {
            return null;
        }
        if (!location.isSet()) {
            return null;
        }
        return location.getURL();
    }

    public static File getEclipseHome() {
        Location eclipseHome;
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.osgi.service.datalocation.Location");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((eclipseHome = (Location)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName(), (String)Location.ECLIPSE_HOME_FILTER)) == null || !eclipseHome.isSet()) {
            return null;
        }
        URL url = eclipseHome.getURL();
        if (url == null) {
            return null;
        }
        return URLUtil.toFile((URL)url);
    }

    private static File[] getLinksDirectories() {
        File configuration;
        ArrayList<File> linksDirectories = new ArrayList<File>();
        File root = Activator.getEclipseHome();
        if (root != null) {
            linksDirectories.add(new File(root, LINKS));
        }
        if (Activator.getParentConfigurationLocation() != null && (configuration = Activator.getConfigurationLocation()) != null && configuration.getParentFile() != null) {
            linksDirectories.add(new File(configuration.getParentFile(), LINKS));
        }
        return linksDirectories.toArray(new File[linksDirectories.size()]);
    }

    private static File[] getDropinsDirectories() {
        File configuration;
        File root;
        ArrayList<File> dropinsDirectories = new ArrayList<File>();
        String watchedDirectoryProperty = bundleContext.getProperty(DROPINS_DIRECTORY);
        if (watchedDirectoryProperty != null) {
            dropinsDirectories.add(new File(watchedDirectoryProperty));
        }
        if ((root = Activator.getEclipseHome()) != null) {
            dropinsDirectories.add(new File(root, DROPINS));
        }
        if (Activator.getParentConfigurationLocation() != null && (configuration = Activator.getConfigurationLocation()) != null && configuration.getParentFile() != null) {
            dropinsDirectories.add(new File(configuration.getParentFile(), DROPINS));
        }
        return dropinsDirectories.toArray(new File[dropinsDirectories.size()]);
    }

    public static IProfile getCurrentProfile(BundleContext context) {
        ServiceReference reference;
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((reference = context.getServiceReference(clazz.getName())) == null) {
            return null;
        }
        IProfileRegistry profileRegistry = (IProfileRegistry)context.getService(reference);
        try {
            IProfile iProfile = profileRegistry.getProfile("_SELF_");
            return iProfile;
        }
        finally {
            context.ungetService(reference);
        }
    }

    private static synchronized void setPackageAdmin(PackageAdmin service) {
        packageAdmin = service;
    }

    static synchronized Bundle getBundle(String symbolicName) {
        if (packageAdmin == null) {
            return null;
        }
        Bundle[] bundles = packageAdmin.getBundles(symbolicName, null);
        if (bundles == null) {
            return null;
        }
        int i = 0;
        while (i < bundles.length) {
            if ((bundles[i].getState() & 3) == 0) {
                return bundles[i];
            }
            ++i;
        }
        return null;
    }
}

