/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.ui.label;

import edu.mit.semantics.core.rep.move.IMove;
import edu.mit.semantics.core.rep.move.MoveRep;
import edu.mit.semantics.ui.SemanticsUIPlugin;
import edu.mit.semantics.ui.label.FunctionLabelProvider;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.label.StoryModelLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class MoveLabelProvider
extends StoryModelLabelProvider {
    protected Image moveImg;
    protected final FunctionLabelProvider functionLP;

    public MoveLabelProvider(IStoryEditor editor) {
        super(editor);
        this.functionLP = new FunctionLabelProvider(editor);
    }

    public StyledString getStyledText(Object element) {
        Object data = element;
        long id = -1L;
        if (data instanceof IDesc) {
            IDesc desc;
            IDesc iDesc = desc = data instanceof IDesc ? (IDesc)data : null;
            if (MoveRep.getInstance().isType((IHasRep)desc)) {
                id = desc.getID();
                data = desc.getData();
            }
        }
        if (data instanceof IMove) {
            IMove move = (IMove)data;
            StyledString result = new StyledString();
            result.append("Move ");
            result.append(Integer.toString(move.getNumber()));
            MoveLabelProvider.appendID((StyledString)result, (long)id);
            if (element instanceof IDesc) {
                MoveLabelProvider.appendMergeTags((StyledString)result, (IDesc)((IDesc)element));
            }
            return result;
        }
        return this.functionLP.getStyledText(data);
    }

    public Image getImage(Object element) {
        if (element instanceof IDesc && MoveRep.getInstance().isType((IHasRep)((IDesc)element))) {
            return this.getMoveImg();
        }
        if (element instanceof IMove) {
            return this.getMoveImg();
        }
        return this.functionLP.getImage(element);
    }

    protected Image getMoveImg() {
        if (this.moveImg == null) {
            this.moveImg = SemanticsUIPlugin.getDefault().getImageRegistry().get("obj16/timelink.gif");
        }
        return this.moveImg;
    }
}

