/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex.tsurgeon;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPattern;
import edu.stanford.nlp.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AuxiliaryTree {
    String originalTreeString;
    Tree tree;
    Tree foot;
    private IdentityHashMap<Tree, String> nodesToNames;
    private Map<String, Tree> namesToNodes;
    String footNodeCharacter = "@";
    Pattern footNodeLabelPattern = Pattern.compile("^(.*)" + this.footNodeCharacter + "$");
    Pattern escapedFootNodeCharacter = Pattern.compile("\\" + this.footNodeCharacter);
    private static String nameIntroducingChar = "=";
    static Pattern namePattern = Pattern.compile(nameIntroducingChar + "(.+)$");
    static Pattern escapedNameChar = Pattern.compile("\\" + nameIntroducingChar);

    public AuxiliaryTree(Tree tree, boolean mustHaveFoot) {
        this.originalTreeString = tree.toString();
        this.foot = this.findFootNode(tree);
        if (this.foot == null && mustHaveFoot) {
            throw new RuntimeException("Error -- no foot node found for " + this.originalTreeString);
        }
        this.tree = tree;
        this.initializeNamesNodesMaps(tree);
    }

    private AuxiliaryTree(Tree tree, Tree foot, Map<String, Tree> namesToNodes) {
        this.tree = tree;
        this.foot = foot;
        this.namesToNodes = namesToNodes;
    }

    public Map<String, Tree> namesToNodes() {
        return this.namesToNodes;
    }

    public String toString() {
        return this.originalTreeString;
    }

    public AuxiliaryTree copy(TsurgeonPattern p) {
        HashMap<String, Tree> newNamesToNodes = new HashMap<String, Tree>();
        Pair<Tree, Tree> result = this.copyHelper(this.tree, newNamesToNodes);
        p.root.newNodeNames.putAll(newNamesToNodes);
        return new AuxiliaryTree(result.first(), result.second(), newNamesToNodes);
    }

    private Pair<Tree, Tree> copyHelper(Tree node, Map<String, Tree> newNamesToNodes) {
        Tree clone;
        Tree newFoot = null;
        if (node.isLeaf()) {
            if (node == this.foot) {
                newFoot = clone = node.treeFactory().newTreeNode(node.label(), new ArrayList(0));
            } else {
                clone = node.treeFactory().newLeaf(node.label().labelFactory().newLabel(node.label()));
            }
        } else {
            ArrayList<Tree> newChildren = new ArrayList<Tree>(node.children().length);
            for (Tree child : node.children()) {
                Pair<Tree, Tree> newChild = this.copyHelper(child, newNamesToNodes);
                newChildren.add(newChild.first());
                if (newChild.second() != null && newFoot != null) {
                    System.err.println("Error -- two feet found when copying auxiliary tree " + this.tree.toString() + "; using last foot found.");
                }
                newFoot = newChild.second();
            }
            clone = node.treeFactory().newTreeNode(node.label().labelFactory().newLabel(node.label()), newChildren);
            if (this.nodesToNames.containsKey(node)) {
                newNamesToNodes.put(this.nodesToNames.get(node), clone);
            }
        }
        return new Pair<Tree, Tree>(clone, newFoot);
    }

    private Tree findFootNode(Tree t) {
        Tree footNode;
        Tree result = footNode = this.findFootNodeHelper(t);
        if (footNode != null) {
            Tree parent = footNode.parent(t);
            int i = parent.indexOf(footNode);
            Tree newFootNode = footNode.treeFactory().newTreeNode(footNode.label(), new ArrayList());
            parent.setChild(i, newFootNode);
            result = newFootNode;
        }
        return result;
    }

    private Tree findFootNodeHelper(Tree t) {
        Tree foundDtr = null;
        if (t.isLeaf()) {
            Matcher m = this.footNodeLabelPattern.matcher(t.label().value());
            if (m.matches()) {
                t.label().setValue(m.group(1));
                return t;
            }
            return null;
        }
        for (Tree child : t.children()) {
            Tree thisFoundDtr = this.findFootNodeHelper(child);
            if (thisFoundDtr == null) continue;
            if (foundDtr != null) {
                throw new RuntimeException("Error -- two foot nodes in subtree" + t.toString());
            }
            foundDtr = thisFoundDtr;
        }
        Matcher m = this.escapedFootNodeCharacter.matcher(t.label().value());
        t.label().setValue(m.replaceAll(this.footNodeCharacter));
        return foundDtr;
    }

    private void initializeNamesNodesMaps(Tree t) {
        this.namesToNodes = new HashMap<String, Tree>();
        this.nodesToNames = new IdentityHashMap();
        for (Tree node : t.subTreeList()) {
            Matcher m = namePattern.matcher(node.label().value());
            if (m.find()) {
                this.namesToNodes.put(m.group(1), node);
                this.nodesToNames.put(node, m.group(1));
                node.label().setValue(m.replaceFirst(""));
            }
            Matcher m1 = escapedNameChar.matcher(node.label().value());
            node.label().setValue(m1.replaceAll(nameIntroducingChar));
        }
    }
}

