/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.io.InDataStreamFile;
import edu.stanford.nlp.io.OutDataStreamFile;
import edu.stanford.nlp.maxent.Feature;
import edu.stanford.nlp.tagger.maxent.FeatureKey;
import edu.stanford.nlp.tagger.maxent.GlobalHolder;
import edu.stanford.nlp.tagger.maxent.TaggerFeatures;

public class TaggerFeature
extends Feature {
    private int start;
    private int end;
    private FeatureKey key;
    private int yTag;

    public TaggerFeature(int start, int end, FeatureKey key) {
        this.start = start;
        this.end = end;
        this.key = key;
        this.yTag = GlobalHolder.tags.getIndex(key.tag);
    }

    public TaggerFeature() {
    }

    public double getVal(int index) {
        return 1.0;
    }

    public int getY(int index) {
        return this.yTag;
    }

    public int len() {
        return this.end - this.start + 1;
    }

    public int getX(int index) {
        return TaggerFeatures.xIndexed[this.start + index];
    }

    public int getYTag() {
        return this.yTag;
    }

    public double getVal(int x, int y) {
        int num = x * GlobalHolder.ySize + y;
        if (this.getYTag() != y) {
            return 0.0;
        }
        int i = 0;
        while (i < this.len()) {
            if (this.getX(i) == num) {
                return 1.0;
            }
            ++i;
        }
        return 0.0;
    }

    public void save(OutDataStreamFile rF) {
        try {
            rF.writeInt(this.start);
            rF.writeInt(this.end);
            this.key.save(rF);
            rF.writeInt(this.yTag);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void read(InDataStreamFile rF) {
        try {
            this.start = rF.readInt();
            this.end = rF.readInt();
            this.key = new FeatureKey();
            this.key.read(rF);
            this.yTag = rF.readInt();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public double ftilde() {
        double s = 0.0;
        int y = this.getYTag();
        int example = this.start;
        while (example < this.end + 1) {
            int x = TaggerFeatures.xIndexed[example];
            s += GlobalHolder.domain.ptildeXY(x, y);
            ++example;
        }
        return s;
    }
}

