/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.ling.Sentence;
import edu.stanford.nlp.ling.SentenceProcessor;
import edu.stanford.nlp.objectbank.TokenizerFactory;
import edu.stanford.nlp.process.DocumentPreprocessor;
import edu.stanford.nlp.process.Function;
import edu.stanford.nlp.process.ListProcessor;
import edu.stanford.nlp.tagger.maxent.CollectionTaggerOutputs;
import edu.stanford.nlp.tagger.maxent.GlobalHolder;
import edu.stanford.nlp.tagger.maxent.TaggerConfig;
import edu.stanford.nlp.tagger.maxent.TestSentence;
import edu.stanford.nlp.util.Timing;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class MaxentTagger
implements Function,
SentenceProcessor,
ListProcessor {
    private static boolean isInitialized = false;
    public static final String DEFAULT_NLP_GROUP_MODEL_PATH = "/u/nlp/data/pos-tagger/wsj3t0-18-left3words/train-wsj-0-18.holder";

    public MaxentTagger() {
    }

    public MaxentTagger(String modelFile) throws Exception {
        MaxentTagger.init(modelFile);
    }

    public static void init(String modelFile) throws Exception {
        if (!isInitialized) {
            GlobalHolder.init();
            boolean read = GlobalHolder.read(modelFile);
            CollectionTaggerOutputs.baseToken -= GlobalHolder.pairs.getSize();
            GlobalHolder.tFeature.init();
            if (read) {
                isInitialized = true;
            }
        }
    }

    public static synchronized String tagString(String toTag) throws Exception {
        if (!isInitialized) {
            MaxentTagger.init(DEFAULT_NLP_GROUP_MODEL_PATH);
        }
        if (isInitialized) {
            try {
                TestSentence ts = new TestSentence(GlobalHolder.prob, toTag);
                return ts.getTaggedNice();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public synchronized Object apply(Object in) {
        if (!isInitialized) {
            try {
                MaxentTagger.init(DEFAULT_NLP_GROUP_MODEL_PATH);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(-1);
            }
        }
        if (isInitialized) {
            try {
                TestSentence ts = new TestSentence();
                Sentence s = (Sentence)in;
                Sentence tagged = ts.tagSentence(GlobalHolder.getLambdaSolve(), s);
                return tagged;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(-1);
            }
        }
        return null;
    }

    public List process(List sentences) {
        ArrayList<Sentence> taggedSentences = new ArrayList<Sentence>();
        TestSentence ts = new TestSentence();
        Iterator iter = sentences.iterator();
        while (iter.hasNext()) {
            taggedSentences.add(ts.tagSentence(GlobalHolder.getLambdaSolve(), (Sentence)iter.next()));
        }
        return taggedSentences;
    }

    public Sentence processSentence(Sentence sentence) {
        return MaxentTagger.tagSentence(sentence);
    }

    public static Sentence tagSentence(Sentence sentence) {
        return new TestSentence().tagSentence(GlobalHolder.getLambdaSolve(), sentence);
    }

    public static List tokenizeText(Reader r) {
        return MaxentTagger.tokenizeText(r, null);
    }

    public static List tokenizeText(Reader r, TokenizerFactory tokenizerFactory) {
        DocumentPreprocessor documentPreprocessor = tokenizerFactory == null ? new DocumentPreprocessor() : new DocumentPreprocessor(tokenizerFactory);
        return documentPreprocessor.getSentencesFromText(r);
    }

    public static void main(String[] args) throws Exception {
        String line;
        BufferedReader br;
        TaggerConfig config = new TaggerConfig(args);
        Date now = new Date();
        System.err.println("## tagger invoked at " + now + " with arguments:");
        config.dump();
        TokenizerFactory tokenizerFactory = null;
        if (!config.getTokenizerFactory().trim().equals("")) {
            tokenizerFactory = (TokenizerFactory)Class.forName(config.getTokenizerFactory()).newInstance();
        }
        Timing t = new Timing();
        System.err.print("Reading POS tagger from " + config.getModel() + " ... ");
        try {
            MaxentTagger.init(config.getModel() + ".holder");
        }
        catch (Exception e) {
            System.err.println();
            e.printStackTrace();
            return;
        }
        System.err.println("done [" + t.toSecondsString() + " sec].");
        t.startTime();
        if (!config.getFile().trim().equalsIgnoreCase("stdin")) {
            br = new BufferedReader(new FileReader(config.getFile()));
        } else {
            System.err.println("Type some text to tag, then EOF.");
            System.err.println("  (For EOF, use Return, Ctrl-D on Unix; Enter, Ctrl-Z, Enter on Windows.)");
            br = new BufferedReader(new InputStreamReader(System.in));
        }
        int numWords = 0;
        while ((line = br.readLine()) != null) {
            if (config.getTokenize()) {
                StringReader r2 = new StringReader(line);
                List l = MaxentTagger.tokenizeText(r2, tokenizerFactory);
                int sz = l.size();
                for (int j = 0; j < sz; ++j) {
                    Sentence s = (Sentence)l.get(j);
                    numWords += s.length();
                    System.out.print(MaxentTagger.tagSentence(s).toString(false) + " ");
                }
                System.out.println();
                continue;
            }
            numWords += new StringTokenizer(line).countTokens();
            System.out.println(MaxentTagger.tagString(line));
        }
        long millis = t.stop();
        double wordspersec = (double)numWords / ((double)millis / 1000.0);
        DecimalFormat nf = new DecimalFormat("0.00");
        System.err.println("Tagged " + numWords + " words at " + nf.format(wordspersec) + " words per second.");
    }
}

