/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.io.InDataStreamFile;
import edu.stanford.nlp.io.OutDataStreamFile;
import edu.stanford.nlp.tagger.maxent.AmbiguityClass;
import edu.stanford.nlp.tagger.maxent.GlobalHolder;
import edu.stanford.nlp.tagger.maxent.TestSentence;
import java.util.HashMap;

public class AmbiguityClasses {
    private HashMap s = new HashMap();
    static String naWord = TestSentence.toSt("NA");
    static String naTag = TestSentence.toSt("NA");

    public AmbiguityClasses() {
        AmbiguityClass.naClass.key = "NA";
        AmbiguityClass.naClass.s.add("NA");
        AmbiguityClass.naClass.init();
    }

    public void init() {
    }

    public int add(AmbiguityClass a) {
        if (this.s.containsKey(a)) {
            return (Integer)this.s.get(a);
        }
        this.s.put(a, new Integer(this.s.size()));
        return this.s.size() - 1;
    }

    public int getClass(String word) {
        if (word.equals(naWord)) {
            return -2;
        }
        if (GlobalHolder.dict.get(word) == null) {
            return -1;
        }
        int allCount = GlobalHolder.dict.sum(word);
        AmbiguityClass a = allCount > GlobalHolder.threshVeryCommon ? new AmbiguityClass(word, true) : new AmbiguityClass(word);
        return this.add(a);
    }

    public void print() {
        Object[] arrClasses = this.s.keySet().toArray();
        System.out.println("Number of ambiguity classes is " + arrClasses.length);
        int i = 0;
        while (i < arrClasses.length) {
            System.out.println(this.add((AmbiguityClass)arrClasses[i]));
            ((AmbiguityClass)arrClasses[i]).print();
            ++i;
        }
    }

    public void save(String filename) {
        try {
            OutDataStreamFile rf = new OutDataStreamFile(filename);
            Object[] arrClasses = this.s.keySet().toArray();
            System.out.println("Number classes is " + arrClasses.length);
            rf.writeInt(arrClasses.length);
            int i = 0;
            while (i < arrClasses.length) {
                rf.writeUTF(((AmbiguityClass)arrClasses[i]).getWord());
                ++i;
            }
            rf.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void read(String filename) {
        try {
            InDataStreamFile rf = new InDataStreamFile(filename);
            int len = rf.readInt();
            int i = 0;
            while (i < len) {
                int len_buff = rf.readInt();
                byte[] buff = new byte[len_buff];
                rf.read(buff);
                String word = new String(buff);
                word = TestSentence.toNice(word);
                this.add(new AmbiguityClass(word));
                this.init();
                ++i;
            }
            System.out.println(" Number of classes " + this.s.size());
            rf.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

