/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.tagger.maxent.ASBCDict;
import edu.stanford.nlp.tagger.maxent.History;
import edu.stanford.nlp.tagger.maxent.PairsHolder;
import edu.stanford.nlp.tagger.maxent.RareExtractor;
import edu.stanford.nlp.tagger.maxent.TestSentence;

class ASBCPreDetector
extends RareExtractor {
    private String t1;
    private int n1;
    private static final long serialVersionUID = 53L;

    public ASBCPreDetector(String t2, int n2) {
        this.t1 = t2;
        this.n1 = n2;
    }

    String extract(History h, PairsHolder pH) {
        String s = TestSentence.toNice(pH.get(h, this.n1, false));
        if (!s.equals("") && ASBCDict.getTagPre(this.t1, s.substring(0, 1)).equals("1")) {
            return "1:" + this.t1;
        }
        return "0:" + this.t1;
    }
}

