/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.process;

import edu.stanford.nlp.ling.BasicDocument;
import edu.stanford.nlp.ling.Document;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.process.AbstractListProcessor;
import edu.stanford.nlp.process.Function;
import edu.stanford.nlp.process.StripTagsProcessor;
import edu.stanford.nlp.process.WhitespaceTokenizer;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PTBEscapingProcessor
extends AbstractListProcessor
implements Function<List<HasWord>, List<HasWord>> {
    protected Map stringSubs;
    protected char[] oldChars;
    protected static final String[] oldStrings = new String[]{"(", ")", "[", "]", "{", "}", "*", "/", "_"};
    protected static final String[] newStrings = new String[]{"-LRB-", "-RRB-", "-LCB-", "-RCB-", "-LCB-", "-RCB-", "\\*", "\\/", "-"};
    protected static final char[] defaultOldChars = new char[]{'*', '/'};
    protected boolean fixQuotes = true;

    public PTBEscapingProcessor() {
        this(PTBEscapingProcessor.makeStringMap(), defaultOldChars, true);
    }

    public PTBEscapingProcessor(Map stringSubs, char[] oldChars, boolean fixQuotes) {
        this.stringSubs = stringSubs;
        this.oldChars = oldChars;
        this.fixQuotes = fixQuotes;
    }

    protected static Map makeStringMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < oldStrings.length; ++i) {
            map.put(oldStrings[i], newStrings[i]);
        }
        return map;
    }

    @Override
    public List<HasWord> apply(List<HasWord> hasWordsList) {
        return this.process(hasWordsList);
    }

    @Override
    public List process(List input) {
        ArrayList<HasWord> output = new ArrayList<HasWord>();
        for (HasWord h : input) {
            String s = h.word();
            String newS = (String)this.stringSubs.get(s);
            if (newS != null) {
                h.setWord(newS);
            } else {
                h.setWord(this.escapeString(s));
            }
            output.add(h);
        }
        if (this.fixQuotes) {
            return this.fixQuotes(output);
        }
        return output;
    }

    private List fixQuotes(List input) {
        int inputSize = input.size();
        LinkedList<HasWord> result = new LinkedList<HasWord>();
        if (inputSize == 0) {
            return result;
        }
        if (((HasWord)input.get(inputSize - 1)).word().equals("\"")) {
            boolean begin = false;
            for (int i = inputSize - 1; i >= 0; --i) {
                HasWord hw = (HasWord)input.get(i);
                String tok = hw.word();
                if (tok.equals("\"")) {
                    if (begin) {
                        hw.setWord("``");
                        begin = false;
                    } else {
                        hw.setWord("''");
                        begin = true;
                    }
                }
                result.addFirst(hw);
            }
        } else {
            boolean begin = true;
            for (int i = 0; i < inputSize; ++i) {
                HasWord hw = (HasWord)input.get(i);
                String tok = hw.word();
                if (tok.equals("\"")) {
                    if (begin) {
                        hw.setWord("``");
                        begin = false;
                    } else {
                        hw.setWord("''");
                        begin = true;
                    }
                }
                result.addLast(hw);
            }
        }
        return result;
    }

    private String escapeString(String s) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char curChar = s.charAt(i);
            if (curChar == '\\') {
                buff.append(curChar);
                if (++i >= s.length()) continue;
                curChar = s.charAt(i);
                buff.append(curChar);
                continue;
            }
            for (int j = 0; j < this.oldChars.length; ++j) {
                if (curChar != this.oldChars[j]) continue;
                buff.append('\\');
                break;
            }
            buff.append(curChar);
        }
        return buff.toString();
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("usage: java edu.stanford.nlp.process.PTBEscapingProcessor fileOrUrl");
            System.exit(0);
        }
        String filename = args[0];
        try {
            Document d = null;
            if (filename.startsWith("http://")) {
                BasicDocument dpre = new BasicDocument(WhitespaceTokenizer.factory()).init(new URL(filename));
                StripTagsProcessor notags = new StripTagsProcessor();
                d = notags.processDocument(dpre);
            } else {
                d = new BasicDocument(WhitespaceTokenizer.factory()).init(new File(filename));
            }
            PTBEscapingProcessor proc = new PTBEscapingProcessor();
            Document newD = proc.processDocument(d);
            for (HasWord word : newD) {
                System.out.println(word);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

