/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.history;

import com.ibm.icu.text.DateFormat;
import java.io.InputStream;
import java.net.URI;
import java.util.Date;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class FileRevisionEditorInput
extends PlatformObject
implements IWorkbenchAdapter,
IStorageEditorInput {
    private final Object fileRevision;
    private final IStorage storage;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public static FileRevisionEditorInput createEditorInputFor(IFileRevision revision, IProgressMonitor monitor) throws CoreException {
        IStorage storage = revision.getStorage(monitor);
        return new FileRevisionEditorInput(revision, storage);
    }

    private static IStorage wrapStorage(final IStorage storage, final String charset) {
        if (charset == null) {
            return storage;
        }
        return new IEncodedStorage(){

            public Object getAdapter(Class adapter) {
                return storage.getAdapter(adapter);
            }

            public boolean isReadOnly() {
                return storage.isReadOnly();
            }

            public String getName() {
                return storage.getName();
            }

            public IPath getFullPath() {
                return storage.getFullPath();
            }

            public InputStream getContents() throws CoreException {
                return storage.getContents();
            }

            public String getCharset() throws CoreException {
                return charset;
            }
        };
    }

    public FileRevisionEditorInput(Object revision, IStorage storage) {
        Assert.isNotNull((Object)revision);
        Assert.isNotNull((Object)storage);
        this.fileRevision = revision;
        this.storage = storage;
    }

    public FileRevisionEditorInput(IFileState state) {
        this(state, (IStorage)state);
    }

    public FileRevisionEditorInput(Object revision, IStorage storage, String charset) {
        this(revision, FileRevisionEditorInput.wrapStorage(storage, charset));
    }

    public IStorage getStorage() throws CoreException {
        return this.storage;
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        IFileState state;
        IFileRevision rev;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.team.core.history.IFileRevision");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((rev = (IFileRevision)this.getAdapter(clazz)) != null) {
            return NLS.bind((String)TeamUIMessages.nameAndRevision, (Object[])new String[]{rev.getName(), rev.getContentIdentifier()});
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IFileState");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((state = (IFileState)this.getAdapter(clazz2)) != null) {
            return String.valueOf(state.getName()) + " " + DateFormat.getInstance().format(new Date(state.getModificationTime()));
        }
        return this.storage.getName();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.storage.getFullPath().toString();
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this;
        }
        Class<?> clazz2 = class$3;
        if (clazz2 == null) {
            try {
                clazz2 = class$3 = Class.forName("org.eclipse.core.resources.IStorage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz2) {
            return this.storage;
        }
        Object object = super.getAdapter(adapter);
        if (object != null) {
            return object;
        }
        return Utils.getAdapter(this.fileRevision, adapter);
    }

    public Object[] getChildren(Object o) {
        return new Object[0];
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    public String getLabel(Object o) {
        IFileRevision rev;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.team.core.history.IFileRevision");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((rev = (IFileRevision)this.getAdapter(clazz)) != null) {
            return rev.getName();
        }
        return this.storage.getName();
    }

    public Object getParent(Object o) {
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FileRevisionEditorInput) {
            FileRevisionEditorInput other = (FileRevisionEditorInput)((Object)obj);
            return other.fileRevision.equals(this.fileRevision);
        }
        return false;
    }

    public int hashCode() {
        return this.fileRevision.hashCode();
    }

    public IFileRevision getFileRevision() {
        if (this.fileRevision instanceof IFileRevision) {
            return (IFileRevision)this.fileRevision;
        }
        return null;
    }

    public URI getURI() {
        if (this.fileRevision instanceof IFileRevision) {
            IFileRevision fr = (IFileRevision)this.fileRevision;
            return fr.getURI();
        }
        return null;
    }
}

