/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.semrole.model;

import edu.mit.parsing.core.rep.pos.IPosTag;
import edu.mit.parsing.core.rep.pos.POSRep;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.semantics.core.rep.semrole.model.IVerbModel;
import edu.mit.story.core.datamodel.DescModel;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.validation.Message;
import org.eclipse.jface.dialogs.IMessageProvider;

public class VerbModel
extends DescModel
implements IVerbModel {
    public static final IMessageProvider noVerb = new Message("A verb or left quote must be selected", 3);
    public static final IMessageProvider nonVerbSelected = new Message("The selected token has a non-Verb part of speech tag: A verb must be selected", 3);
    public static final IMessageProvider auxVerbSelected = new Message("The selected token is an auxiliary verb: A main verb must be selected", 3);

    public VerbModel(IStoryModel storyModel) {
        super(storyModel, new IRep[]{TokenRep.getInstance()});
    }

    protected IMessageProvider calculateMessage() {
        if (this.getDesc() != null) {
            IDescSet tagDescs = this.getStoryModel().getData().getDescriptions(POSRep.getInstance());
            tagDescs = tagDescs.openSet((IHasPosition)this.getDesc());
            boolean isQuote = false;
            boolean isAux = false;
            boolean hasVerb = false;
            boolean hasNonVerb = false;
            for (IDesc desc : tagDescs) {
                IPosTag tag = (IPosTag)desc.getData();
                isQuote |= tag.getTag().getTagString().equals("``");
                isAux |= tag.isAuxiliary();
                hasVerb |= tag.getTag().isVerb();
                hasNonVerb |= !tag.getTag().isVerb();
            }
            if (!isQuote) {
                if (hasVerb && hasNonVerb) {
                    return nonVerbSelected;
                }
                if (isAux) {
                    return auxVerbSelected;
                }
                if (hasNonVerb) {
                    return noVerb;
                }
            }
        }
        return super.calculateMessage();
    }
}

