/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.move.model;

import edu.mit.semantics.core.rep.function.FunctionTag;
import edu.mit.semantics.core.rep.function.IFunction;
import edu.mit.semantics.core.rep.move.IMove;
import edu.mit.semantics.core.rep.move.Move;
import edu.mit.semantics.core.rep.move.model.IMoveModel;
import edu.mit.story.core.align.IAlignedStoryModel;
import edu.mit.story.core.datamodel.AbstractViewModel;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IStructuredData;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.notify.INotifyCollectionCallback;
import edu.mit.story.core.notify.NotifyingList;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.PositionUtils;
import edu.mit.story.core.validation.Message;
import java.util.List;
import org.eclipse.jface.dialogs.IMessageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveModel
extends AbstractViewModel
implements IMoveModel {
    private int number = this.getDefaultNumber();
    private IDesc loaded = null;
    private List<IDesc> functions = new NotifyingList((INotifyCollectionCallback)new INotifyCollectionCallback<IDesc>(){

        public void elementAdded(IDesc added) {
            MoveModel.this.fireChanged();
        }

        public void elementRemoved(IDesc removed) {
            MoveModel.this.fireChanged();
        }
    });

    @Override
    public int getNumber() {
        return this.number;
    }

    @Override
    public List<IDesc> getFunctions() {
        return this.functions;
    }

    @Override
    public void setNumber(int newNumber) {
        if (newNumber < 1) {
            newNumber = 1;
        }
        if (newNumber == this.number) {
            return;
        }
        this.number = newNumber;
        this.fireChanged();
    }

    public IHasPosition calculatePosition() {
        if (this.functions.isEmpty()) {
            return null;
        }
        return PositionUtils.combineAll(this.functions);
    }

    public IHasPosition getDisplayPosition() {
        return this.calculatePosition();
    }

    protected IMessageProvider calculateMessage() {
        IDesc repeat = this.findRepeat();
        if (repeat != null) {
            IFunction func = (IFunction)repeat.getData();
            StringBuilder sb = new StringBuilder();
            sb.append("The function '");
            sb.append(FunctionTag.serialize(func.getFunctionTag()));
            sb.append("' occurs more than once in the move");
            return new Message(sb.toString(), 3);
        }
        return Message.NO_MESSAGE;
    }

    protected IDesc findRepeat() {
        int i = 0;
        while (i < this.functions.size()) {
            if (this.functions.subList(i + 1, this.functions.size()).contains(this.functions.get(i))) {
                return this.functions.get(i);
            }
            ++i;
        }
        return null;
    }

    protected int getDefaultNumber() {
        return 1;
    }

    protected void internalClear() {
        this.loaded = null;
        this.number = this.getDefaultNumber();
        this.functions.clear();
    }

    public boolean isCleared() {
        if (this.loaded != null) {
            return false;
        }
        if (this.number != this.getDefaultNumber()) {
            return false;
        }
        return this.functions.isEmpty();
    }

    public IStructuredData recalculate(IDesc container, IStoryModel model) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(IData tgtData, IAlignedStoryModel model) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IMove create() {
        return new Move(this.number, this.functions);
    }

    @Override
    public IDesc getLoaded() {
        return this.loaded;
    }

    @Override
    public void load(IDesc desc) {
        IMove move = (IMove)desc.getData();
        this.clear();
        this.loaded = desc;
        this.number = move.getNumber();
        this.functions.addAll(move.getFunctions());
    }
}

