/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.event.problems;

import edu.mit.semantics.core.rep.event.Aspect;
import edu.mit.semantics.core.rep.event.EventRep;
import edu.mit.semantics.core.rep.event.IEvent;
import edu.mit.semantics.core.rep.event.Tense;
import edu.mit.story.core.build.StoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.util.EntryImpl;
import java.util.Collections;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnexpectedTenseAspectProblem
extends StoryProblem {
    public static final String ID = "edu.mit.semantics.event.problem.unexpectedTenseAspect";

    public UnexpectedTenseAspectProblem(IDesc desc, Tense tense, Aspect aspect, String buildRuleID) {
        this(Collections.singletonMap(desc, new EntryImpl((Object)tense, (Object)aspect)), buildRuleID);
    }

    public UnexpectedTenseAspectProblem(Map<IDesc, Map.Entry<Tense, Aspect>> descs, String buildRuleID) {
        super(EventRep.getInstance(), buildRuleID);
        this.setID(ID);
        this.setName("possibly incorrect tense or aspect");
        this.setSeverity(1);
        this.setDescs(descs.keySet());
        IDescSet ds = this.getDescs().getDescriptions(EventRep.getInstance());
        if (ds.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.setPosition((IHasPosition)ds.first());
        this.setCheck(ID);
        StringBuilder sb = new StringBuilder();
        if (ds.size() == 1) {
            IDesc d = (IDesc)ds.first();
            IEvent event = (IEvent)d.getData();
            Map.Entry<Tense, Aspect> e = descs.get(ds.first());
            boolean tense = e.getKey() != null;
            boolean aspect = e.getValue() != null;
            boolean both = tense && aspect;
            sb.append("The event '");
            sb.append(event.getEventTokens().getDisplayText());
            sb.append("' has a potentially incorrect ");
            if (tense) {
                sb.append("tense of ");
                sb.append(event.getTense().getName());
            }
            if (both) {
                sb.append(" and ");
            }
            if (aspect) {
                sb.append("aspect of ");
                sb.append(event.getAspect().getName());
            }
            sb.append("; ");
            sb.append(both ? "they" : "it");
            sb.append(" should probably be ");
            if (tense) {
                sb.append(e.getKey().getName());
            }
            if (both) {
                sb.append(" and ");
            }
            if (aspect) {
                sb.append(e.getValue().getName());
            }
        } else {
            sb.append("There are ");
            sb.append(Integer.toString(ds.size()));
            sb.append(" events that have tense or aspect that are potentially incorrect");
        }
        this.setDescription(sb.toString());
    }
}

