/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.wizards.page;

import edu.mit.story.core.datamodel.IBatchTargetModel;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.controllers.IBatchTargetController;
import edu.mit.story.ui.util.ColorManager;
import java.io.File;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.model.WorkbenchLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectTargetBatchPage
extends WizardPage {
    public static final String NAME = SelectTargetBatchPage.class.getSimpleName();
    private final IBatchTargetController<? extends IBatchTargetModel> controller;
    protected ListViewer listViewer;
    protected Text directoryPathField;
    protected static String previouslyBrowsedDirectory = "";

    public SelectTargetBatchPage(IBatchTargetController<? extends IBatchTargetModel> controller) {
        this(NAME, controller);
    }

    public SelectTargetBatchPage(String pageName, IBatchTargetController<? extends IBatchTargetModel> controller) {
        super(pageName);
        if (controller == null) {
            throw new NullPointerException();
        }
        this.controller = controller;
    }

    public void createControl(Composite parent) {
        parent = new Composite(parent, 0);
        parent.setLayout((Layout)new GridLayout(2, false));
        this.listViewer = new ListViewer(parent, 2562);
        this.listViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.listViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.listViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.listViewer.setInput((Object)this.controller.getModel().getTargets());
        Composite lefthandButtons = new Composite(parent, 0);
        lefthandButtons.setLayoutData((Object)new GridData(4, 4, false, true, 1, 3));
        lefthandButtons.setFont(parent.getFont());
        lefthandButtons.setLayout((Layout)new GridLayout(1, true));
        Button button = new Button(lefthandButtons, 8);
        button.setText("&Add");
        button.setLayoutData((Object)new GridData(256));
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                SelectTargetBatchPage.this.controller.selectTargets(SelectTargetBatchPage.this.getShell());
            }
        });
        button = new Button(lefthandButtons, 8);
        button.setText("&Remove");
        button.setLayoutData((Object)new GridData(256));
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = SelectionUtils.castAsStructuredSelection(SelectTargetBatchPage.this.listViewer.getSelection());
                Object[] objectArray = sel.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    SelectTargetBatchPage.this.controller.removeTarget((IFile)obj);
                    ++n2;
                }
            }
        });
        button = new Button(lefthandButtons, 8);
        button.setText("&Select All");
        button.setLayoutData((Object)new GridData(256));
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                SelectTargetBatchPage.this.listViewer.getList().selectAll();
            }
        });
        button = new Button(lefthandButtons, 8);
        button.setText("&Deselect All");
        button.setLayoutData((Object)new GridData(256));
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                SelectTargetBatchPage.this.listViewer.getList().deselectAll();
            }
        });
        Label label = new Label(parent, 0);
        label.setText("Output Folder");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        ColorManager.inheritColors((Control)label);
        this.directoryPathField = new Text(parent, 2048);
        this.directoryPathField.setEditable(false);
        this.directoryPathField.setBackground(Display.getDefault().getSystemColor(25));
        this.directoryPathField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label spacer = new Label(lefthandButtons, 0);
        spacer.setLayoutData((Object)new GridData(4, 4, false, true));
        Button browse = new Button(lefthandButtons, 0);
        browse.setText("&Browse...");
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String dir = SelectTargetBatchPage.this.selectDirectory();
                SelectTargetBatchPage.this.controller.getModel().setOutput(dir == null ? null : new File(dir));
            }
        });
        this.setControl(this.listViewer.getControl());
        this.controller.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SelectTargetBatchPage.this.updateFromModel();
            }
        });
        this.updateFromModel();
    }

    protected void updateFromModel() {
        String path;
        IBatchTargetModel model = this.controller.getModel();
        this.listViewer.refresh();
        File outputFile = model.getOutputFile();
        String string = path = outputFile == null ? "" : outputFile.getPath();
        if (!this.directoryPathField.getText().equals(path)) {
            this.directoryPathField.setText(path);
        }
        this.setMessage(model.getMessage(), model.getMessageType());
        this.setPageComplete(model.getMessageType() != 3);
    }

    protected String selectDirectory() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setMessage("Select the destination folder");
        String dirName = this.directoryPathField.getText().trim();
        if (dirName.length() == 0) {
            dirName = previouslyBrowsedDirectory;
        }
        if (dirName.length() == 0) {
            dialog.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString());
        } else {
            File path = new File(dirName);
            if (path.exists()) {
                dialog.setFilterPath(new Path(dirName).toOSString());
            }
        }
        String selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            previouslyBrowsedDirectory = selectedDirectory;
        }
        return selectedDirectory;
    }
}

