/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.ops;

import edu.mit.story.core.util.LogUtils;
import edu.mit.story.ui.StoryUIMessages;
import edu.mit.story.ui.StoryUIPlugin;
import edu.mit.story.ui.WorkbenchUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class CreateFileOperation
extends WorkspaceModifyOperation {
    public static final int DEFAULT_TOTAL_WORK = 10000;
    private final IFile file;
    private final InputStream content;
    private final int totalWork;

    public CreateFileOperation(IPath path) {
        this(WorkbenchUtils.convertToFile(path), null);
    }

    public CreateFileOperation(IPath tgtPath, IPath srcPath) {
        this(WorkbenchUtils.convertToFile(tgtPath), CreateFileOperation.getContent(srcPath), 10000);
    }

    public CreateFileOperation(IPath path, InputStream content) {
        this(WorkbenchUtils.convertToFile(path), content, 10000);
    }

    public CreateFileOperation(IPath path, InputStream content, int totalWork) {
        this(WorkbenchUtils.convertToFile(path), content, totalWork);
    }

    public CreateFileOperation(IFile file) {
        this(file, null);
    }

    public CreateFileOperation(IFile file, InputStream content) {
        this(file, content, 10000);
    }

    public CreateFileOperation(IFile file, InputStream content, int totalWork) {
        super(WorkbenchUtils.getSchedulingRule(file));
        this.file = file;
        this.content = content;
        this.totalWork = totalWork < 1 ? 10000 : totalWork;
    }

    public IFile getFile() {
        return this.file;
    }

    public InputStream getContent() {
        return this.content;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        if (monitor.isCanceled()) {
            return;
        }
        this.doBeginTask(monitor);
        try {
            this.doCreateFile(monitor);
        }
        finally {
            monitor.done();
        }
    }

    protected void doBeginTask(IProgressMonitor monitor) {
        String message = NLS.bind((String)StoryUIMessages.MSG_PROGRESS_CreatingFile, (Object)this.file.getName());
        monitor.beginTask(message, this.totalWork);
    }

    protected void doCreateFile(IProgressMonitor monitor) throws CoreException {
        this.file.create(this.content, false, (IProgressMonitor)new SubProgressMonitor(monitor, this.totalWork));
    }

    public static InputStream getContent(IPath path) {
        try {
            return new FileInputStream(path.toFile());
        }
        catch (IOException e) {
            LogUtils.logError((Plugin)StoryUIPlugin.getDefault(), (Throwable)e);
            return null;
        }
    }
}

