/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.handlers;

import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.widgets.HelperPageBookWidget;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.PageBookView;

public class ShowHelperHandler
extends AbstractHandler {
    private final String paramID;
    private final String viewID;

    public ShowHelperHandler(String paramID, String viewID) {
        if (paramID.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        if (viewID.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        this.paramID = paramID;
        this.viewID = viewID;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        PageBookView view;
        String creatorID = event.getParameter(this.paramID);
        if (creatorID == null) {
            return null;
        }
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        IWorkbenchPage activePage = window.getActivePage();
        IViewPart part = null;
        if (activePage != null) {
            try {
                part = activePage.showView(this.viewID);
            }
            catch (PartInitException e) {
                throw new ExecutionException(null, (Throwable)e);
            }
        }
        if ((view = SelectionUtils.cast(part, PageBookView.class)) == null) {
            return null;
        }
        Control control = view.getCurrentPage().getControl();
        HelperPageBookWidget widget = SelectionUtils.cast(control, HelperPageBookWidget.class);
        if (widget == null) {
            return null;
        }
        widget.showPage(creatorID);
        return null;
    }
}

