/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.artifact.mirror;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.ArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;

public class Mirroring {
    private IArtifactRepository source;
    private IArtifactRepository destination;
    private boolean raw;

    public Mirroring(IArtifactRepository source, IArtifactRepository destination, boolean raw) {
        this.source = source;
        this.destination = destination;
        this.raw = raw;
    }

    public void run() {
        if (!this.destination.isModifiable()) {
            throw new IllegalStateException("Destination repository must be modifiable: " + this.destination.getLocation());
        }
        IArtifactKey[] keys = this.source.getArtifactKeys();
        int i = 0;
        while (i < keys.length) {
            IArtifactKey key = keys[i];
            IArtifactDescriptor[] descriptors = this.source.getArtifactDescriptors(key);
            int j = 0;
            while (j < descriptors.length) {
                this.mirror(descriptors[j]);
                ++j;
            }
            ++i;
        }
    }

    private void mirror(IArtifactDescriptor descriptor) {
        IArtifactDescriptor newDescriptor = this.raw ? descriptor : new ArtifactDescriptor(descriptor);
        try {
            OutputStream repositoryStream = null;
            try {
                System.out.println("Mirroring: " + descriptor.getArtifactKey());
                repositoryStream = this.destination.getOutputStream(newDescriptor);
                if (repositoryStream == null) {
                    return;
                }
                this.source.getArtifact(descriptor, repositoryStream, (IProgressMonitor)new NullProgressMonitor());
            }
            finally {
                if (repositoryStream != null) {
                    repositoryStream.close();
                }
            }
        }
        catch (ProvisionException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

