/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import org.eclipse.compare.contentmergeviewer.ITokenComparator;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public class DocLineComparator
implements ITokenComparator {
    private IDocument fDocument;
    private int fLineOffset;
    private int fLineCount;
    private int fLength;
    private boolean fIgnoreWhiteSpace;

    public DocLineComparator(IDocument document, IRegion region, boolean ignoreWhiteSpace) {
        this.fDocument = document;
        this.fIgnoreWhiteSpace = ignoreWhiteSpace;
        this.fLineOffset = 0;
        if (region != null) {
            this.fLength = region.getLength();
            int start = region.getOffset();
            try {
                this.fLineOffset = this.fDocument.getLineOfOffset(start);
            }
            catch (BadLocationException badLocationException) {}
            if (this.fLength == 0) {
                this.fLineCount = 0;
            } else {
                int endLine = this.fDocument.getNumberOfLines();
                try {
                    endLine = this.fDocument.getLineOfOffset(start + this.fLength);
                }
                catch (BadLocationException badLocationException) {}
                this.fLineCount = endLine - this.fLineOffset + 1;
            }
        } else {
            this.fLength = document.getLength();
            this.fLineCount = this.fDocument.getNumberOfLines();
        }
    }

    public int getRangeCount() {
        return this.fLineCount;
    }

    public int getTokenStart(int line) {
        try {
            IRegion r = this.fDocument.getLineInformation(this.fLineOffset + line);
            return r.getOffset();
        }
        catch (BadLocationException badLocationException) {
            return this.fDocument.getLength();
        }
    }

    public int getTokenLength(int line) {
        return this.getTokenStart(line + 1) - this.getTokenStart(line);
    }

    public boolean rangesEqual(int thisIndex, IRangeComparator otherComparator, int otherIndex) {
        if (otherComparator != null && otherComparator.getClass() == this.getClass()) {
            int olen;
            DocLineComparator other = (DocLineComparator)otherComparator;
            if (this.fIgnoreWhiteSpace) {
                String s1 = this.extract(thisIndex);
                String s2 = other.extract(otherIndex);
                return this.compare(s1, s2);
            }
            int tlen = this.getTokenLength(thisIndex);
            if (tlen == (olen = other.getTokenLength(otherIndex))) {
                String s1 = this.extract(thisIndex);
                String s2 = other.extract(otherIndex);
                return s1.equals(s2);
            }
        }
        return false;
    }

    public boolean skipRangeComparison(int length, int maxLength, IRangeComparator other) {
        return false;
    }

    private String extract(int line) {
        if (line < this.fLineCount) {
            try {
                IRegion r = this.fDocument.getLineInformation(this.fLineOffset + line);
                return this.fDocument.get(r.getOffset(), r.getLength());
            }
            catch (BadLocationException badLocationException) {}
        }
        return "";
    }

    private boolean compare(String s1, String s2) {
        int l1 = s1.length();
        int l2 = s2.length();
        int c1 = 0;
        int c2 = 0;
        int i1 = 0;
        int i2 = 0;
        while (c1 != -1) {
            char c;
            c1 = -1;
            while (i1 < l1) {
                if (Character.isWhitespace(c = s1.charAt(i1++))) continue;
                c1 = c;
                break;
            }
            c2 = -1;
            while (i2 < l2) {
                if (Character.isWhitespace(c = s2.charAt(i2++))) continue;
                c2 = c;
                break;
            }
            if (c1 == c2) continue;
            return false;
        }
        return true;
    }
}

