/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.subversion.merge.actions;

import com.collabnet.subversion.merge.wizards.CustomWizardDialog;
import com.collabnet.subversion.merge.wizards.MergeWizard;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.wizard.IWizard;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.actions.WorkbenchWindowAction;

public class MergeAction
extends WorkbenchWindowAction {
    protected void execute(IAction action) throws InvocationTargetException, InterruptedException {
        if (action != null && !action.isEnabled()) {
            action.setEnabled(true);
        } else {
            IResource[] resources = this.getSelectedResources();
            MergeWizard wizard = new MergeWizard(resources, this.getTargetPart());
            CustomWizardDialog dialog = new CustomWizardDialog(this.shell, (IWizard)wizard);
            dialog.open();
        }
    }

    protected boolean isEnabledForManagedResources() {
        return true;
    }

    protected boolean isEnabledForUnmanagedResources() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isEnabledForMultipleResources() {
        try {
            ISVNRepositoryLocation repository = null;
            IResource[] selectedResources = this.getSelectedResources();
            int i = 0;
            while (true) {
                if (i >= selectedResources.length) {
                    return true;
                }
                ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)selectedResources[i]);
                if (svnResource == null || !svnResource.isManaged()) {
                    return false;
                }
                if (repository != null && !svnResource.getRepository().equals(repository)) {
                    return false;
                }
                repository = svnResource.getRepository();
                ++i;
            }
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected String getImageId() {
        return "Menu Merge";
    }
}

