/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.subversion.merge;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.client.OperationManager;
import org.tigris.subversion.subclipse.core.commands.ISVNCommand;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class CopyCommand
implements ISVNCommand {
    private SVNWorkspaceRoot root;
    private SVNUrl srcUrl;
    private File destPath;
    private SVNRevision svnRevision;

    public CopyCommand(SVNWorkspaceRoot root, SVNUrl srcUrl, File destPath, SVNRevision svnRevision) {
        this.root = root;
        this.srcUrl = srcUrl;
        this.destPath = destPath;
        this.svnRevision = svnRevision;
    }

    public void run(IProgressMonitor monitor) throws SVNException {
        try {
            try {
                monitor.beginTask(null, 100);
                ISVNClientAdapter svnClient = this.root.getRepository().getSVNClient();
                OperationManager.getInstance().beginOperation(svnClient);
                monitor.subTask(this.destPath.getName());
                svnClient.copy(this.srcUrl, this.destPath, this.svnRevision, false, true);
                monitor.worked(100);
            }
            catch (SVNClientException e) {
                throw SVNException.wrapException((Exception)((Object)e));
            }
        }
        finally {
            OperationManager.getInstance().endOperation();
            monitor.done();
        }
    }
}

