/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.ui.dialogs;

import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.wordnet.core.rep.sense.changes.DisambiguationChange;
import edu.mit.wordnet.ui.WordnetUIPlugin;
import edu.mit.wordnet.ui.wizards.pages.DisambiguationPage;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionEvent;

public class SenseEditorDialog
extends WizardDialog {
    public SenseEditorDialog(IDesc desc, IStoryEditor editor) {
        super(editor.getEditorSite().getShell(), (IWizard)new SenseEditorWizard(desc, editor));
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = WordnetUIPlugin.getDefault().getDialogSettings();
        IDialogSettings result = settings.getSection(((Object)((Object)this)).getClass().getCanonicalName());
        if (result == null) {
            result = new DialogSettings(((Object)((Object)this)).getClass().getCanonicalName());
            settings.addSection(result);
            result.put("width", 960);
            result.put("height", 6400);
        }
        return result;
    }

    public static boolean open(IDesc desc, IStoryEditor editor) {
        SenseEditorDialog dialog = new SenseEditorDialog(desc, editor);
        dialog.setBlockOnOpen(true);
        dialog.open();
        return dialog.getReturnCode() == 1;
    }

    protected static class SenseEditorWizard
    extends Wizard {
        private final DisambiguationPage page;
        private final IStoryEditor editor;

        public SenseEditorWizard(IDesc desc, IStoryEditor editor) {
            if (editor == null) {
                throw new NullPointerException();
            }
            this.editor = editor;
            this.page = new DisambiguationPage(desc, editor){

                protected void choiceDefaultSelected(SelectionEvent e) {
                    IWizardContainer container = this.getContainer();
                    if (container instanceof SenseEditorDialog) {
                        SenseEditorDialog dialog = (SenseEditorDialog)container;
                        dialog.finishPressed();
                    }
                }
            };
            this.addPage((IWizardPage)this.page);
        }

        public boolean performFinish() {
            DisambiguationChange change = new DisambiguationChange(this.page.getController().getModel());
            this.editor.getStoryModel().applyChange((Object)this, (IModelChange)change, false);
            return true;
        }
    }
}

