/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.update;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.viewers.update.DebugEventHandler;
import org.eclipse.debug.internal.ui.viewers.update.DefaultExpressionModelProxy;
import org.eclipse.debug.internal.ui.viewers.update.ExpressionEventHandler;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class DefaultWatchExpressionModelProxy
extends DefaultExpressionModelProxy
implements IDebugContextListener {
    private IWorkbenchWindow fWindow;

    public DefaultWatchExpressionModelProxy(IWatchExpression expression) {
        super((IExpression)expression);
    }

    public void installed(final Viewer viewer) {
        super.installed(viewer);
        UIJob job = new UIJob("install watch expression model proxy"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (!DefaultWatchExpressionModelProxy.this.isDisposed()) {
                    IWorkbenchWindow[] workbenchWindows = PlatformUI.getWorkbench().getWorkbenchWindows();
                    int i = 0;
                    while (i < workbenchWindows.length) {
                        IWorkbenchWindow window = workbenchWindows[i];
                        if (viewer.getControl().getShell().equals(window.getShell())) {
                            DefaultWatchExpressionModelProxy.this.fWindow = window;
                            break;
                        }
                        ++i;
                    }
                    if (DefaultWatchExpressionModelProxy.this.fWindow == null) {
                        DefaultWatchExpressionModelProxy.this.fWindow = DebugUIPlugin.getActiveWorkbenchWindow();
                    }
                    IDebugContextService contextService = DebugUITools.getDebugContextManager().getContextService(DefaultWatchExpressionModelProxy.this.fWindow);
                    contextService.addDebugContextListener(DefaultWatchExpressionModelProxy.this);
                    ISelection activeContext = contextService.getActiveContext();
                    if (activeContext != null) {
                        DefaultWatchExpressionModelProxy.this.contextActivated(activeContext);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public synchronized void dispose() {
        super.dispose();
        if (this.fWindow != null) {
            DebugUITools.getDebugContextManager().getContextService(this.fWindow).removeDebugContextListener(this);
            this.fWindow = null;
        }
    }

    protected DebugEventHandler[] createEventHandlers() {
        return new DebugEventHandler[]{new ExpressionEventHandler(this)};
    }

    protected void contextActivated(ISelection selection) {
        if (this.fWindow != null && selection instanceof IStructuredSelection) {
            IWatchExpression expression;
            IDebugElement context = null;
            IStructuredSelection ss = (IStructuredSelection)selection;
            if (ss.size() < 2) {
                Object object = ss.getFirstElement();
                if (object instanceof IDebugElement) {
                    context = (IDebugElement)object;
                } else if (object instanceof ILaunch) {
                    context = ((ILaunch)object).getDebugTarget();
                }
            }
            if ((expression = (IWatchExpression)this.getExpression()) != null) {
                expression.setExpressionContext(context);
            }
        }
    }

    public void debugContextChanged(DebugContextEvent event) {
        if ((event.getFlags() & 1) > 0) {
            this.contextActivated(event.getContext());
        }
    }
}

