/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.semrole.rules;

import com.google.common.collect.HashMultimap;
import edu.mit.parsing.core.rep.colloc.CollocRep;
import edu.mit.parsing.core.rep.colloc.IColloc;
import edu.mit.parsing.core.rep.pos.IPosTag;
import edu.mit.parsing.core.rep.pos.POSRep;
import edu.mit.semantics.core.rep.semrole.ISemRole;
import edu.mit.semantics.core.rep.semrole.SemRoleRep;
import edu.mit.semantics.core.rep.semrole.problems.MultiplyTaggedVerbProblem;
import edu.mit.semantics.core.rep.semrole.problems.UntaggedVerbProblem;
import edu.mit.story.core.build.AbstractBuildRule;
import edu.mit.story.core.build.IStoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.meta.check.CheckMetaRep;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.core.rep.IHasRep;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerbTaggingRule
extends AbstractBuildRule {
    public VerbTaggingRule() {
        super(SemRoleRep.getInstance());
    }

    public IHasPositionSet<IStoryProblem> build(IStoryModel model) {
        IDesc verb;
        HashMultimap semroleMap = HashMultimap.create();
        for (IDesc semroleDesc : model.getData().getDescriptions(SemRoleRep.getInstance())) {
            ISemRole semrole = (ISemRole)semroleDesc.getData();
            verb = (IDesc)semrole.getPredicate().getTokens().first();
            semroleMap.put((Object)verb, (Object)semroleDesc);
        }
        HashSet<IDesc> untaggedVerbs = new HashSet<IDesc>();
        HashSet tokensTaggedAsMWEs = new HashSet();
        block1: for (IDesc desc : model.getData().getDescriptions(POSRep.getInstance())) {
            IPosTag tag = (IPosTag)desc.getData();
            verb = tag.getWord();
            if (!tag.getTag().isVerb() || tag.isAuxiliary()) continue;
            if (CollocRep.getInstance().isType((IHasRep)verb)) {
                IColloc mwe = (IColloc)verb.getData();
                for (IDesc d : mwe.getTokens()) {
                    if (semroleMap.get((Object)d).isEmpty()) continue;
                    tokensTaggedAsMWEs.addAll(mwe.getTokens());
                    continue block1;
                }
                continue;
            }
            if (!semroleMap.get((Object)verb).isEmpty()) continue;
            untaggedVerbs.add(verb);
        }
        untaggedVerbs.removeAll(tokensTaggedAsMWEs);
        Iterator i = semroleMap.asMap().entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            if (((Collection)entry.getValue()).size() < 2) {
                i.remove();
                continue;
            }
            if (!CheckMetaRep.isChecked((IDesc)((IDesc)entry.getKey()), (String)"edu.mit.semantics.core.problem.multipleSemroles")) continue;
            i.remove();
        }
        if (semroleMap.isEmpty() && untaggedVerbs.isEmpty()) {
            return null;
        }
        HasPositionSet result = new HasPositionSet();
        for (IDesc untagged : untaggedVerbs) {
            result.add((Object)new UntaggedVerbProblem(untagged, this.getID()));
        }
        for (Collection multiple : semroleMap.asMap().values()) {
            result.add((Object)new MultiplyTaggedVerbProblem(multiple, this.getID()));
        }
        return result;
    }
}

