/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.position;

import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.PositionUtils;
import edu.mit.story.core.util.Immutable;

public class SimplePosition
implements IHasPosition,
Immutable {
    private final int offset;
    private final int length;
    private final int right;

    public SimplePosition(IHasPosition p) {
        this(p.getOffset(), p.getLength());
    }

    public SimplePosition(int offset, int length) {
        if (offset < 0) {
            throw new IllegalArgumentException();
        }
        if (length < 0) {
            throw new IllegalArgumentException();
        }
        this.offset = offset;
        this.length = length;
        this.right = offset + length;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public int getRightOffset() {
        return this.right;
    }

    public String toString() {
        return PositionUtils.toString(this);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.length;
        result = 31 * result + this.offset;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimplePosition other = (SimplePosition)obj;
        if (this.length != other.length) {
            return false;
        }
        return this.offset == other.offset;
    }
}

