/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.IntPair;
import edu.stanford.nlp.util.IntQuadruple;
import edu.stanford.nlp.util.IntTriple;
import edu.stanford.nlp.util.IntUni;
import java.io.Serializable;
import java.util.ArrayList;

public class IntTuple
implements Serializable {
    int[] elements;
    private static final long serialVersionUID = 7266305463893511982L;

    public IntTuple(int[] arr) {
        this.elements = arr;
    }

    public IntTuple(int num) {
        this.elements = new int[num];
    }

    public int get(int num) {
        return this.elements[num];
    }

    public void set(int num, int val) {
        this.elements[num] = val;
    }

    public void shiftLeft() {
        int j = 0;
        while (j < this.elements.length - 1) {
            this.elements[j] = this.elements[j + 1];
            ++j;
        }
        this.elements[this.elements.length - 1] = 0;
    }

    public IntTuple getCopy() {
        IntTuple copy = IntTuple.getIntTuple(this.elements.length);
        int i = 0;
        while (i < this.elements.length) {
            copy.set(i, this.elements[i]);
            ++i;
        }
        return copy;
    }

    public int[] elems() {
        return this.elements;
    }

    public boolean equals(Object iO) {
        if (!(iO instanceof IntTuple)) {
            return false;
        }
        IntTuple i = (IntTuple)iO;
        if (i.elements.length != this.elements.length) {
            return false;
        }
        int j = 0;
        while (j < this.elements.length) {
            if (this.elements[j] != i.get(j)) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public int hashCode() {
        int sum = 0;
        int i = 0;
        while (i < this.elements.length) {
            sum += this.elements[i] * this.elements[i];
            ++i;
        }
        return sum;
    }

    public int length() {
        return this.elements.length;
    }

    public IntTuple() {
    }

    public static IntTuple getIntTuple(int num) {
        if (num == 1) {
            return new IntUni();
        }
        if (num == 2) {
            return new IntPair();
        }
        if (num == 3) {
            return new IntTriple();
        }
        if (num == 4) {
            return new IntQuadruple();
        }
        return new IntTuple(num);
    }

    public static IntTuple getIntTuple(ArrayList integers) {
        IntTuple t = IntTuple.getIntTuple(integers.size());
        int i = 0;
        while (i < t.length()) {
            t.set(i, (Integer)integers.get(i));
            ++i;
        }
        return t;
    }

    public String toString() {
        String name = "";
        int i = 0;
        while (i < this.elements.length) {
            name = String.valueOf(name) + this.get(i);
            if (i < this.elements.length - 1) {
                name = String.valueOf(name) + " ";
            }
            ++i;
        }
        return name;
    }

    public static IntTuple concat(IntTuple t1, IntTuple t2) {
        int n1 = t1.length();
        int n2 = t2.length();
        IntTuple res = IntTuple.getIntTuple(n1 + n2);
        int j = 0;
        while (j < n1) {
            res.set(j, t1.get(j));
            ++j;
        }
        int i = 0;
        while (i < n2) {
            res.set(n1 + i, t2.get(i));
            ++i;
        }
        return res;
    }

    public void print() {
        String s = this.toString();
        System.out.print(s);
    }
}

