/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.trees.CompositeTreebank;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.LabeledScoredTreeReaderFactory;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.MyTreeTransformer;
import edu.stanford.nlp.trees.MyTreeTransformer2;
import edu.stanford.nlp.trees.MyTreeTransformer3;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeReader;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.TreeVisitor;
import edu.stanford.nlp.trees.Treebank;
import edu.stanford.nlp.util.Timing;
import java.io.File;
import java.io.FileFilter;
import java.io.Reader;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformingTreebank
extends Treebank {
    TreeTransformer transformer;
    Treebank tf;
    Iterator iter = null;

    public TransformingTreebank() {
        this(new LabeledScoredTreeReaderFactory());
    }

    public TransformingTreebank(String encoding) {
        this(new LabeledScoredTreeReaderFactory(), encoding);
    }

    public TransformingTreebank(TreeReaderFactory trf) {
        super(trf);
    }

    public TransformingTreebank(TreeReaderFactory trf, String encoding) {
        super(trf, encoding);
    }

    public TransformingTreebank(Treebank tf, TreeTransformer transformer) {
        this.tf = tf;
        this.transformer = transformer;
    }

    @Override
    public void clear() {
        this.tf.clear();
        this.transformer = null;
    }

    @Override
    public void loadPath(File path, FileFilter filt) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void apply(TreeVisitor tp) {
        for (Tree t : this.tf) {
            Tree tmpT = t.deeperCopy();
            if (this.transformer != null) {
                tmpT = this.transformer.transformTree(tmpT);
            }
            tp.visitTree(tmpT);
        }
    }

    @Override
    public Iterator<Tree> iterator() {
        if (this.iter == null) {
            this.iter = new TransformingTreebankIterator(this.tf.iterator());
        }
        return this.iter;
    }

    public static void main(String[] args) {
        Timing.startTime();
        DiskTreebank treebank = new DiskTreebank(new TreeReaderFactory(){

            public TreeReader newTreeReader(Reader in) {
                return new PennTreeReader(in, new LabeledScoredTreeFactory());
            }
        });
        MemoryTreebank treebank2 = new MemoryTreebank(new TreeReaderFactory(){

            public TreeReader newTreeReader(Reader in) {
                return new PennTreeReader(in, new LabeledScoredTreeFactory());
            }
        });
        treebank.loadPath(args[0]);
        treebank2.loadPath(args[0]);
        CompositeTreebank c = new CompositeTreebank(treebank, treebank2);
        Timing.endTime();
        MyTreeTransformer myTransformer = new MyTreeTransformer();
        MyTreeTransformer2 myTransformer2 = new MyTreeTransformer2();
        MyTreeTransformer3 myTransformer3 = new MyTreeTransformer3();
        Treebank tf = c.transform(myTransformer).transform(myTransformer2).transform(myTransformer3);
        System.out.println(c);
        System.out.println("-------------------------");
        System.out.println(tf);
        System.out.println("-------------------------");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TransformingTreebankIterator
    implements Iterator<Tree> {
        Iterator<Tree> iter = null;

        TransformingTreebankIterator(Iterator<Tree> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Tree next() {
            if (this.iter.hasNext()) {
                Tree ret = this.iter.next();
                if (TransformingTreebank.this.transformer != null) {
                    ret = TransformingTreebank.this.transformer.transformTree(ret);
                }
                return ret;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

