/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class CtbDict {
    private static final String defaultFilename = "/juice/scr1/htseng/maxent/maxent-20040930/pos-task4/data/genfeature/ctb_dict.txt.no.vn";
    private static CtbDict CtbDictSingleton = null;
    public static HashMap<String, Set<String>> ctb_pre_dict;
    public static HashMap<String, Set<String>> ctb_suf_dict;

    public static CtbDict getInstance() {
        if (CtbDictSingleton == null) {
            CtbDictSingleton = new CtbDict(0);
        }
        return CtbDictSingleton;
    }

    private CtbDict(int i) {
        try {
            CtbDict.readCtbDict(defaultFilename);
        }
        catch (IOException e) {
            throw new RuntimeException("can't open file: " + e.getMessage());
        }
    }

    private static void readCtbDict(String filename) throws IOException {
        String ctbDetectorLine;
        BufferedReader ctbDetectorReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "GB18030"));
        ctb_pre_dict = new HashMap();
        ctb_suf_dict = new HashMap();
        while ((ctbDetectorLine = ctbDetectorReader.readLine()) != null) {
            String[] fields = ctbDetectorLine.split("\t");
            String tag = fields[0];
            Set<String> pres = ctb_pre_dict.get(tag);
            Set<String> sufs = ctb_suf_dict.get(tag);
            if (pres == null) {
                pres = new HashSet<String>();
                ctb_pre_dict.put(tag, pres);
            }
            pres.add(fields[1]);
            if (sufs == null) {
                sufs = new HashSet<String>();
                ctb_suf_dict.put(tag, sufs);
            }
            sufs.add(fields[2]);
        }
    }

    public static String getTagPre(String a1, String a2) {
        CtbDict dict = CtbDict.getInstance();
        if (dict.getpre(a1) == null) {
            return "0";
        }
        if (dict.getpre(a1).contains(a2)) {
            return "1";
        }
        return "0";
    }

    public static String getTagSuf(String a1, String a2) {
        CtbDict dict = CtbDict.getInstance();
        if (dict.getsuf(a1) == null) {
            return "0";
        }
        if (dict.getsuf(a1).contains(a2)) {
            return "1";
        }
        return "0";
    }

    Set getpre(String a) {
        return ctb_pre_dict.get(a);
    }

    Set getsuf(String a) {
        return ctb_suf_dict.get(a);
    }
}

