/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.swing;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontDetector {
    public static final int NUM_LANGUAGES = 1;
    public static final int CHINESE = 0;
    public static final String[][] unicodeRanges = new String[1][];

    private FontDetector() {
    }

    public static List<Font> supportedFonts(int language) {
        if (language < 0 || language > 1) {
            throw new IllegalArgumentException();
        }
        ArrayList<Font> fonts = new ArrayList<Font>();
        Font[] systemFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        for (int i = 0; i < systemFonts.length; ++i) {
            boolean canDisplay = true;
            for (int j = 0; j < unicodeRanges[language].length; ++j) {
                if (systemFonts[i].canDisplayUpTo(unicodeRanges[language][j]) == -1) continue;
                canDisplay = false;
                break;
            }
            if (!canDisplay) continue;
            fonts.add(systemFonts[i]);
        }
        return fonts;
    }

    public static boolean hasFont(String fontName) {
        Font[] systemFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        for (int i = 0; i < systemFonts.length; ++i) {
            if (!systemFonts[i].getName().equalsIgnoreCase(fontName)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        List<Font> fonts = FontDetector.supportedFonts(0);
        System.err.println("Has MS Mincho? " + FontDetector.hasFont("MS Mincho"));
        for (Font font : fonts) {
            System.out.println(font.getName());
        }
    }

    static {
        FontDetector.unicodeRanges[0] = new String[]{"\u3001", "\uff01", "\uffee", "\u0374", "\u3126"};
    }
}

