/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.StringLabel;
import edu.stanford.nlp.ling.StringLabelFactory;
import edu.stanford.nlp.parser.lexparser.CNFTransformers;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import java.util.ArrayList;

class Debinarizer
implements TreeTransformer {
    private TreeFactory tf;
    private TreebankLanguagePack tlp;
    private boolean forceCNF;

    private void removeRoot(Tree t) {
        if (!this.tlp.isStartSymbol(t.label().value())) {
            return;
        }
        Tree[] origChildren = t.children();
        Tree[] children = new Tree[origChildren.length - 1];
        System.arraycopy(origChildren, 0, children, 0, origChildren.length - 1);
        t.setChildren(children);
    }

    protected Tree transformTreeHelper(Tree t) {
        if (t.isLeaf()) {
            Tree leaf = this.tf.newLeaf(new StringLabel(t.label().value()));
            leaf.setScore(t.score());
            return leaf;
        }
        ArrayList<Tree> newChildren = new ArrayList<Tree>(20);
        StringLabel label = new StringLabel(t.label().value());
        for (int childNum = 0; childNum < t.numChildren(); ++childNum) {
            Tree child = t.getChild(childNum);
            Tree newChild = this.transformTreeHelper(child);
            if (!newChild.isLeaf() && newChild.label().value().indexOf(64) >= 0) {
                newChildren.addAll(newChild.getChildrenAsList());
                continue;
            }
            newChildren.add(newChild);
        }
        Tree node = this.tf.newTreeNode(label, newChildren);
        node.setScore(t.score());
        return node;
    }

    public Tree transformTree(Tree t) {
        Tree result = this.transformTreeHelper(t);
        if (this.forceCNF) {
            result = new CNFTransformers.FromCNFTransformer().transformTree(result);
        }
        this.removeRoot(result);
        return result;
    }

    public Debinarizer(TreebankLanguagePack tlp, boolean forceCNF) {
        this.tlp = tlp;
        this.forceCNF = forceCNF;
        this.tf = new LabeledScoredTreeFactory(new StringLabelFactory());
    }
}

