/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.wizards.page;

import edu.mit.story.ui.StoryUIMessages;
import edu.mit.story.ui.StoryUIPlugin;
import edu.mit.story.ui.controllers.IRepSelectionController;
import edu.mit.story.ui.controllers.RepSelectionConsistentController;
import edu.mit.story.ui.model.IChangeRepSelectionModel;
import edu.mit.story.ui.widgets.RepresentationSetGroup;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecifyChangeRepsPage
extends WizardPage {
    public static final String NAME = SpecifyChangeRepsPage.class.getCanonicalName();
    protected final IRepSelectionController<? extends IChangeRepSelectionModel> controller;
    protected RepresentationSetGroup chosenReps;

    public SpecifyChangeRepsPage(IChangeRepSelectionModel model) {
        this(new RepSelectionConsistentController<IChangeRepSelectionModel>(model));
    }

    public SpecifyChangeRepsPage(IRepSelectionController<? extends IChangeRepSelectionModel> controller) {
        super(NAME);
        if (controller == null) {
            throw new NullPointerException();
        }
        this.setTitle(StoryUIMessages.WIZARD_PAGE_SpecifyChangeRepresentations_title);
        this.setDescription(StoryUIMessages.WIZARD_PAGE_SpecifyChangeRepresentations_description);
        this.setImageDescriptor(StoryUIPlugin.getDefault().getImageRegistry().getDescriptor("wizban/representation_wiz.gif"));
        this.controller = controller;
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        top.setLayoutData((Object)data);
        top.setLayout((Layout)new GridLayout());
        this.setControl((Control)top);
        this.chosenReps = new RepresentationSetGroup(top, StoryUIMessages.RepresentationSetGroup_List_title, true, false, this.controller);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        this.chosenReps.setLayoutData(data);
        this.controller.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SpecifyChangeRepsPage.this.updateFromModel();
            }
        });
        this.updateFromModel();
    }

    protected void updateFromModel() {
        boolean newRepsUnselected;
        IChangeRepSelectionModel model = this.controller.getModel();
        if (!model.getNewlyUnselected().isEmpty()) {
            this.setMessage("Some initially checked representations have been unchecked. They will be deleted from the set of representations for the story.", 2);
            newRepsUnselected = true;
        } else {
            this.setMessage(StoryUIMessages.WIZARD_PAGE_SpecifyChangeRepresentations_description, 0);
            newRepsUnselected = false;
        }
        boolean newRepsSelected = !model.getNewlySelected().isEmpty();
        this.setPageComplete(newRepsUnselected || newRepsSelected);
    }
}

