/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.widgets;

import edu.mit.story.core.descriptor.DescriptorLabelFormatter;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.util.IFormatter;
import edu.mit.story.ui.StoryUIMessages;
import edu.mit.story.ui.controllers.IRepSelectionController;
import edu.mit.story.ui.controllers.RepSelectionConsistentController;
import edu.mit.story.ui.label.RepresentationLabelProvider;
import edu.mit.story.ui.model.IRepSelectionModel;
import edu.mit.story.ui.model.RepSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepresentationSetGroup
extends Composite {
    protected final IRepSelectionController<? extends IRepSelectionModel> controller;
    protected final boolean isRequiredGroup;
    protected final boolean showWarningLabel;
    protected final String title;
    protected CheckboxTableViewer tableViewer;

    public RepresentationSetGroup(Composite parent) {
        this(parent, null, true, false, new RepSelectionConsistentController<RepSelectionModel>(new RepSelectionModel()));
    }

    public RepresentationSetGroup(Composite parent, String title, boolean showWarningLabel, boolean isRequiredGroup, IRepSelectionController<? extends IRepSelectionModel> controller) {
        super(parent, 0);
        if (controller == null) {
            throw new NullPointerException();
        }
        if (title == null) {
            title = "Representations";
        }
        this.title = title;
        this.isRequiredGroup = isRequiredGroup;
        this.showWarningLabel = showWarningLabel;
        this.controller = controller;
        this.createContents(this);
    }

    protected void createContents(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        Label titleLabel = new Label(parent, 64);
        String labelTitle = String.valueOf(this.title) + (this.controller.isConsistent() ? StoryUIMessages.MSG_Asterix : "");
        titleLabel.setText(labelTitle);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        titleLabel.setLayoutData((Object)data);
        this.tableViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2052);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new RepresentationLabelProvider((IFormatter<? super IRep>)DescriptorLabelFormatter.NAME_PAREN_ID, false));
        data = new GridData();
        data.horizontalSpan = 2;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        this.tableViewer.getTable().setLayoutData((Object)data);
        this.tableViewer.setInput(this.controller.getModel().getSupported());
        this.tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (RepresentationSetGroup.this.isRequiredGroup) {
                    RepresentationSetGroup.this.getController().setRequired((IRep)event.getElement(), event.getChecked());
                } else {
                    RepresentationSetGroup.this.getController().setSelected((IRep)event.getElement(), event.getChecked());
                }
                RepresentationSetGroup.this.updateFromModel();
            }
        });
        this.tableViewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                TableItem item = (TableItem)e.item;
                IRep rep = (IRep)item.getData();
                if (RepresentationSetGroup.this.isRequiredGroup) {
                    RepresentationSetGroup.this.getController().toggleRequired(rep);
                } else {
                    RepresentationSetGroup.this.getController().toggleSelected(rep);
                }
                RepresentationSetGroup.this.updateFromModel();
            }
        });
        if (this.controller.isConsistent() && this.showWarningLabel) {
            Label asterixLabel = new Label(parent, 0);
            asterixLabel.setText(StoryUIMessages.MSG_Asterix);
            Label warningLabel = new Label(parent, 64);
            warningLabel.setText(StoryUIMessages.MSG_AntecedentsWillBeChecked);
            data = new GridData();
            data.grabExcessHorizontalSpace = true;
            data.horizontalAlignment = 4;
            warningLabel.setLayoutData((Object)data);
            new Label(parent, 0);
            warningLabel = new Label(parent, 64);
            warningLabel.setText(StoryUIMessages.MSG_DependentsWillBeUnchecked);
            data = new GridData();
            data.grabExcessHorizontalSpace = true;
            data.horizontalAlignment = 4;
            warningLabel.setLayoutData((Object)data);
        }
        this.getController().getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                RepresentationSetGroup.this.updateFromModel();
            }
        });
        this.updateFromModel();
    }

    public IRepSelectionController<? extends IRepSelectionModel> getController() {
        return this.controller;
    }

    public void updateFromModel() {
        IRepSelectionModel model = this.getController().getModel();
        try {
            this.tableViewer.getTable().setRedraw(false);
            this.tableViewer.update((Object)model, null);
            if (this.isRequiredGroup) {
                for (IRep rep : model.getSupported()) {
                    this.tableViewer.setAllGrayed(false);
                    boolean state = this.tableViewer.getChecked((Object)rep);
                    if (state == model.isRequired(rep)) continue;
                    this.tableViewer.setChecked((Object)rep, !state);
                }
            } else {
                for (IRep rep : model.getSupported()) {
                    boolean state = this.tableViewer.getGrayed((Object)rep);
                    if (state != model.isRequired(rep)) {
                        this.tableViewer.setGrayed((Object)rep, !state);
                    }
                    if ((state = this.tableViewer.getChecked((Object)rep)) == model.isIncluded(rep)) continue;
                    this.tableViewer.setChecked((Object)rep, !state);
                }
            }
        }
        finally {
            this.tableViewer.getTable().setRedraw(true);
        }
    }

    public CheckboxTableViewer getTableViewer() {
        return this.tableViewer;
    }
}

