/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.widgets;

import edu.mit.story.core.descriptor.IHasDescription;
import edu.mit.story.core.descriptor.IHasName;
import edu.mit.story.ui.widgets.ButtonEnumGroup;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckboxEnumGroup<T extends Enum<T>>
extends ButtonEnumGroup<T> {
    protected final Set<T> values = new HashSet<T>();
    protected Set<T> valuesExternal = Collections.unmodifiableSet(this.values);

    public CheckboxEnumGroup(Class<T> enumType) {
        super(enumType);
    }

    public Set<T> getValues() {
        return this.valuesExternal;
    }

    public void setValues(Set<T> newValues) {
        if (newValues == null) {
            newValues = Collections.emptySet();
        }
        if (newValues.contains(null)) {
            throw new IllegalArgumentException();
        }
        if (this.buttons != null) {
            Button[] buttonArray = this.buttons;
            int n = this.buttons.length;
            int n2 = 0;
            while (n2 < n) {
                Button button = buttonArray[n2];
                button.setSelection(newValues.contains(button.getData()));
                ++n2;
            }
        }
        this.values.clear();
        this.values.addAll(newValues);
        this.notifyChangeListeners();
    }

    @Override
    protected void createButtons(Composite parent) {
        Enum[] valArray = (Enum[])this.enumType.getEnumConstants();
        if (valArray == null || valArray.length == 0) {
            throw new IllegalStateException();
        }
        boolean hasName = IHasName.class.isAssignableFrom(this.getEnumType());
        boolean hasDesc = IHasDescription.class.isAssignableFrom(this.getEnumType());
        this.buttons = new Button[valArray.length];
        int i = 0;
        while (i < valArray.length) {
            Button button;
            Enum enumValue = valArray[i];
            this.buttons[i] = button = new Button(parent, 16416);
            String text = hasName ? ((IHasName)enumValue).getName() : enumValue.name();
            button.setText(text);
            if (hasDesc) {
                button.setToolTipText(((IHasDescription)enumValue).getDescription());
            }
            button.setData((Object)enumValue);
            button.setSelection(this.values.contains(enumValue));
            button.addSelectionListener((SelectionListener)new SelectionAdapter(button){
                Button myButton;
                {
                    this.myButton = button;
                }

                public void widgetSelected(SelectionEvent event) {
                    Enum v = (Enum)this.myButton.getData();
                    HashSet newValues = new HashSet(CheckboxEnumGroup.this.values);
                    if (this.myButton.getSelection() ? !newValues.add(v) : !newValues.remove(v)) {
                        return;
                    }
                    CheckboxEnumGroup.this.setValues(newValues);
                    CheckboxEnumGroup.this.notifyChangeListeners();
                    CheckboxEnumGroup.this.notifySelectionListeners(event);
                }
            });
            ++i;
        }
    }

    @Override
    protected void doValidate() {
    }
}

