/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.viewers;

import edu.mit.story.ui.viewers.ITableItemConfigurer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListViewerComponent<E> {
    public static final int EVENT_OK_ENABLE = 1;
    public static final int EVENT_OK_DISABLE = 2;
    private Display fDisplay;
    private Table fTable;
    private ITableItemConfigurer<E> fConfigurer;
    private boolean fReadyForSelection;
    private int fVisibleItemCount;
    private List<E> fHistory;
    private List<E> fResults;

    public ListViewerComponent(Composite parent, int style, ITableItemConfigurer<E> configurer) {
        if (configurer == null) {
            throw new IllegalArgumentException("ITableItemConfigurer cannot be null");
        }
        this.fDisplay = parent.getDisplay();
        this.fConfigurer = configurer;
        this.fTable = new Table(parent, style);
        this.fTable.setFont(parent.getFont());
        this.fTable.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                int itemHeight = ListViewerComponent.this.fTable.getItemHeight();
                Rectangle clientArea = ListViewerComponent.this.fTable.getClientArea();
                ListViewerComponent.this.fVisibleItemCount = clientArea.height / itemHeight + 1;
            }
        });
        this.fConfigurer.initialize(this.fTable);
        this.fHistory = new ArrayList(500);
        this.fResults = new ArrayList(500);
        this.fReadyForSelection = false;
    }

    public void setLayoutData(Object layoutData) {
        this.fTable.setLayoutData(layoutData);
    }

    public boolean setFocus() {
        return this.fTable.setFocus();
    }

    public void addSelectionListener(SelectionListener listener) {
        this.fTable.addSelectionListener(listener);
    }

    public boolean canWait() {
        return this.fVisibleItemCount < this.fResults.size() + this.fHistory.size();
    }

    public int getHistoryCount() {
        return this.fHistory.size();
    }

    public int getResultsCount() {
        return this.fResults.size();
    }

    public int getTotalCount() {
        return this.getHistoryCount() + this.getResultsCount();
    }

    public int getSeparatorIndex() {
        if (this.fHistory.size() == 0 | this.fResults.size() == 0) {
            return -1;
        }
        return this.fHistory.size();
    }

    public Table getTable() {
        return this.fTable;
    }

    public E getSelection() {
        int i = this.fTable.getSelectionIndex();
        if (i != -1) {
            return (E)this.fTable.getItem(i).getData();
        }
        if (this.fHistory.size() > 0) {
            return this.fHistory.get(0);
        }
        if (this.fResults.size() > 0) {
            return this.fResults.get(0);
        }
        return null;
    }

    public boolean selectionExists() {
        return this.fReadyForSelection;
    }

    public void clearHistory() {
        this.fHistory.clear();
    }

    public void setHistory(List<E> words) {
        this.fHistory.clear();
        this.appendHistoryItems(words);
    }

    public void appendHistoryItem(E word) {
        this.fHistory.add(word);
        this.invokeWithUIThread(new SynchronizeHistory(this.fHistory.size() - 1, this.fHistory.size()));
    }

    public void appendHistoryItems(List<E> items) {
        int startIndex = this.fHistory.size();
        this.fHistory.addAll(items);
        this.invokeWithUIThread(new SynchronizeHistory(startIndex, this.fHistory.size()));
    }

    public void setResults(List<E> items) {
        this.fResults.clear();
        this.appendResultItems(items);
        this.finalizeDisplay();
    }

    public void clearResults() {
        this.fResults.clear();
    }

    public void appendResultItem(E item) {
        if (this.fHistory.contains(item)) {
            return;
        }
        this.fResults.add(item);
        this.invokeWithUIThread(new SynchronizeResults(this.fResults.size() - 1, this.fResults.size(), false));
    }

    public void appendResultItems(Collection<E> items) {
        ArrayList<E> newItems = new ArrayList<E>(items);
        newItems.removeAll(this.fHistory);
        int startIndex = this.fResults.size();
        this.fResults.addAll(newItems);
        this.invokeWithUIThread(new SynchronizeResults(startIndex, this.fResults.size(), false));
    }

    public void finalizeDisplay() {
        this.invokeWithUIThread(new SynchronizeResults(this.fResults.size(), this.fResults.size(), true));
    }

    protected void configureTableItem(TableItem tableItem, E item) {
        if (tableItem == null) {
            return;
        }
        if (item == null) {
            tableItem.setData(null);
            tableItem.setImage(null);
            tableItem.setText("");
            tableItem.setForeground(this.fTable.getForeground());
        } else {
            this.fConfigurer.configure(tableItem, item);
        }
    }

    protected void configureSeparatorItem(TableItem item) {
        if (item == null) {
            return;
        }
        this.fConfigurer.configureSeparator(item);
    }

    protected void setReadyForSelection(boolean value) {
        this.fReadyForSelection = value;
        Event event = new Event();
        if (this.fReadyForSelection) {
            event.doit = true;
            this.fTable.notifyListeners(13, event);
        } else {
            event.doit = false;
            this.fTable.notifyListeners(13, event);
        }
    }

    private void invokeWithUIThread(Runnable run) {
        if (this.fTable.isDisposed()) {
            return;
        }
        this.fDisplay.syncExec(run);
    }

    protected class SynchronizeHistory
    implements Runnable {
        private int startIndex;
        private int endIndex;

        public SynchronizeHistory(int start, int end) {
            if (end < start) {
                throw new IllegalArgumentException("Ending index cannot be less than starting index");
            }
            this.startIndex = start;
            this.endIndex = end;
        }

        public void run() {
            TableItem item;
            boolean useSeparator = ListViewerComponent.this.fResults.size() != 0 & ListViewerComponent.this.fHistory.size() != 0;
            int i = this.startIndex;
            while (i < this.endIndex) {
                if (ListViewerComponent.this.fTable.isDisposed()) {
                    return;
                }
                item = i < ListViewerComponent.this.fTable.getItemCount() ? ListViewerComponent.this.fTable.getItem(i) : new TableItem(ListViewerComponent.this.fTable, 0);
                ListViewerComponent.this.configureTableItem(item, ListViewerComponent.this.fHistory.get(i));
                ++i;
            }
            if (this.endIndex == ListViewerComponent.this.fHistory.size() & useSeparator) {
                item = this.endIndex < ListViewerComponent.this.fTable.getItemCount() ? ListViewerComponent.this.fTable.getItem(this.endIndex) : new TableItem(ListViewerComponent.this.fTable, 0);
                ListViewerComponent.this.configureSeparatorItem(item);
            }
        }
    }

    protected class SynchronizeResults
    implements Runnable {
        private int startIndex;
        private int endIndex;
        private boolean fFinalize;

        public SynchronizeResults(int start, int end, boolean finalize) {
            if (end < start) {
                throw new IllegalArgumentException("Ending index cannot be less than starting index");
            }
            this.startIndex = start;
            this.endIndex = end;
            this.fFinalize = finalize;
        }

        public void run() {
            TableItem item;
            int startResults;
            int i = this.startIndex;
            boolean useSeparator = ListViewerComponent.this.fResults.size() != 0 & ListViewerComponent.this.fHistory.size() != 0;
            if (useSeparator) {
                startResults = ListViewerComponent.this.fHistory.size() + 1;
                if (i == 0) {
                    item = ListViewerComponent.this.fHistory.size() < ListViewerComponent.this.fTable.getItemCount() ? ListViewerComponent.this.fTable.getItem(ListViewerComponent.this.fHistory.size()) : new TableItem(ListViewerComponent.this.fTable, 0);
                    ListViewerComponent.this.configureSeparatorItem(item);
                }
            } else {
                startResults = ListViewerComponent.this.fHistory.size();
            }
            while (i < this.endIndex) {
                if (ListViewerComponent.this.fTable.isDisposed()) {
                    return;
                }
                item = startResults + i < ListViewerComponent.this.fTable.getItemCount() ? ListViewerComponent.this.fTable.getItem(startResults + i) : new TableItem(ListViewerComponent.this.fTable, 0);
                if (i < ListViewerComponent.this.fResults.size()) {
                    ListViewerComponent.this.configureTableItem(item, ListViewerComponent.this.fResults.get(i));
                }
                ++i;
            }
            if (this.fFinalize) {
                if (ListViewerComponent.this.fTable.isDisposed()) {
                    return;
                }
                if (startResults + i < ListViewerComponent.this.fTable.getItemCount()) {
                    ListViewerComponent.this.fTable.remove(startResults + i, ListViewerComponent.this.fTable.getItemCount() - 1);
                }
            }
            ListViewerComponent.this.setReadyForSelection(ListViewerComponent.this.fTable.getItemCount() > 0);
        }
    }
}

